package com.gmei.callable;

import com.gmei.bean.MaidianOpen;
import com.gmei.utils.JDBCUtils;

import java.sql.*;
import java.util.concurrent.Callable;

/**
 * ClassName: com.gmei.callable.MaidianCallable
 * Function: TODO ADD FUNCTION.
 * Reason: 查询客户端埋点数据
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class MaidianCallable implements Callable<MaidianOpen> {
    private String app_session_id;
    private Connection connection;
    private String date;
    private String tableName;
    private String serial_id;
    private String jdbcUrl;
    private String device_id;

    public MaidianCallable(String app_session_id, Connection connection, String date,String tableName,String serial_id,String jdbcUrl,String device_id) {
        this.app_session_id = app_session_id;
        this.connection = connection;
        this.date = date;
        this.tableName = tableName;
        this.serial_id = serial_id;
        this.jdbcUrl = jdbcUrl;
        this.device_id = device_id;
    }

    @Override
    public MaidianOpen call() throws Exception {
        return findMaidian(app_session_id,connection,date,jdbcUrl,serial_id,tableName,device_id);
    }

    private MaidianOpen findMaidian(String app_session_id, Connection connection, String date,String jdbcUrl,String serial_id,String tableName,String device_id) throws SQLException {
        if(connection == null || connection.isClosed()){
            connection = DriverManager.getConnection(jdbcUrl);
        }
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(String.format("select app_session_id,date,serial_id from %s where app_session_id = '%s' and date = '%s' and serial_id = '%s' and cl_id = '%s'"
                ,tableName, app_session_id, date,serial_id,device_id));

        MaidianOpen maidianOpen = new MaidianOpen();
        if(resultSet.next()){
            maidianOpen.setApp_session_id(resultSet.getString(1));
            maidianOpen.setDate(resultSet.getString(2));
            maidianOpen.setSerial_id(resultSet.getString(3));
        }
        JDBCUtils.close(null,statement,resultSet);
        return maidianOpen;
    }
}
