package com.gmei.cache;

import com.gmei.bean.dim.DimPageType;
import com.gmei.jdbc.MysqlJdbcDim;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

/**
 * ClassName: DimPageTypeDao
 * Function:
 * Reason: dim_page_type页面名称标准化就三级分类码表数据库操作类
 * Date: 2019/12/10 下午7:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DimPageTypeDao {

    private MysqlJdbcDim mysqlJdbcDim;
    private ResultSet resultSet;
    private String sql;
    private Connection conn;
    private String dimJdbcUrl;

    public DimPageTypeDao() {
    }

    public DimPageTypeDao(String dimJdbcUrl) {
        this.dimJdbcUrl = dimJdbcUrl;
        this.mysqlJdbcDim = MysqlJdbcDim.getInstance(dimJdbcUrl);
    }

    /**
    * Function: findAllDimPageType
    * Reason: 查询所有页面信息（gengmei_user）
    * Date: 2019/12/25 下午5:23
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList<DimPageType> findAllDimPageType(String tableName) {
        mysqlJdbcDim.getConnection();
        sql = String.format(
                "select code, pk, name, memo, " +
                "       parent_app_code, parent_app_pk, parent_app_name, " +
                "       type_s_code, type_s_name, " +
                "       type_m_code, type_m_name, " +
                "       type_l_code, type_l_name " +
                "  from %s" +
                " where parent_app_code = 'gengmei_user'", tableName);
        ArrayList<DimPageType> dimPageTypeList = new ArrayList<>();
        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {
                DimPageType dimPageType = new DimPageType();
                dimPageType.setCode(resultSet.getString(1));
                dimPageType.setPk(resultSet.getString(2));
                dimPageType.setName(resultSet.getString(3));
                dimPageType.setMemo(resultSet.getString(4));
                dimPageType.setParent_app_code(resultSet.getString(5));
                dimPageType.setParent_app_pk(resultSet.getString(6));
                dimPageType.setParent_app_name(resultSet.getString(7));
                dimPageType.setType_s_code(resultSet.getString(8));
                dimPageType.setType_s_name(resultSet.getString(9));
                dimPageType.setType_m_code(resultSet.getString(10));
                dimPageType.setType_m_name(resultSet.getString(11));
                dimPageType.setType_l_code(resultSet.getString(12));
                dimPageType.setType_l_name(resultSet.getString(13));
                dimPageTypeList.add(dimPageType);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            mysqlJdbcDim.close(null, null, resultSet);
        }
        return dimPageTypeList;
    }

    /**
    * Function: findDimPageTypeByCode
    * Reason: 根据页面编码查询页面信息（gengmei_user）
    * Date: 2019/12/25 下午5:23
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public DimPageType findDimPageTypeByCode(String tableName, String code){
        if (code == null || code.trim().length() == 0) {
            return null;
        } else {
            code = code.trim();
        }
        mysqlJdbcDim.getConnection();
        String sql = String.format(
                "select code, pk, name, memo, " +
                "       parent_app_code, parent_app_pk, parent_app_name, " +
                "       type_s_code, type_s_name, " +
                "       type_m_code, type_m_name, " +
                "       type_l_code, type_l_name " +
                "  from %s" +
                " where parent_app_code = 'gengmei_user'" +
                "   and code = '%s'", tableName, code);
//        ArrayList<DimPageType> dimPageTypeList = new ArrayList<>();
        DimPageType dimPageType = new DimPageType();

        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {
                dimPageType.setCode(code);
                dimPageType.setPk(resultSet.getString(2));
                dimPageType.setName(resultSet.getString(3));
                dimPageType.setMemo(resultSet.getString(4));
                dimPageType.setParent_app_code(resultSet.getString(5));
                dimPageType.setParent_app_pk(resultSet.getString(6));
                dimPageType.setParent_app_name(resultSet.getString(7));
                dimPageType.setType_s_code(resultSet.getString(8));
                dimPageType.setType_s_name(resultSet.getString(9));
                dimPageType.setType_m_code(resultSet.getString(10));
                dimPageType.setType_m_name(resultSet.getString(11));
                dimPageType.setType_l_code(resultSet.getString(12));
                dimPageType.setType_l_name(resultSet.getString(13));
//                dimPageTypeList.add(dimPageType);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            mysqlJdbcDim.close(null, null, resultSet);
        }
        return dimPageType;
    }
}
