package com.gmei.cache;

import com.gmei.bean.dim.DimTable;
import com.gmei.jdbc.MysqlJdbcDim;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

/**
 * ClassName: DimTableDao
 * Function:
 * Reason: 通用Dim码表
 * Date: 2019/12/10 下午7:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DimTableDao {

    private MysqlJdbcDim mysqlJdbcDim;
    private ResultSet resultSet;
    private String sql;
    private Connection conn;
    private String dimJdbcUrl;

    public DimTableDao() {
    }

    public DimTableDao(String dimJdbcUrl) {
        this.dimJdbcUrl = dimJdbcUrl;
        this.mysqlJdbcDim = MysqlJdbcDim.getInstance(dimJdbcUrl);
    }

    /**
    * Function: findAllDimTable
    * Reason: 查询所有码表信息
    * Date: 2019/12/25 下午5:26
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList<DimTable> findAllDimTable(String tableName) {
        mysqlJdbcDim.getConnection();
        sql = String.format("select code, pk, name, memo from %s", tableName);
        ArrayList<DimTable> dimTableList = new ArrayList<>();
        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {
                DimTable dim_table = new DimTable();
                dim_table.setCode(resultSet.getString(1));
                dim_table.setPk(resultSet.getString(2));
                dim_table.setName(resultSet.getString(3));
                dim_table.setMemo(resultSet.getString(4));
                dimTableList.add(dim_table);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            mysqlJdbcDim.close(null, null, resultSet);
        }
        return dimTableList;
    }

    /**
    * Function: findDimTableByCode
    * Reason: 根据编码查询码表信息
    * Date: 2019/12/25 下午5:26
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public DimTable findDimTableByCode(String tableName, String code){
        if (code == null || code.trim().length() == 0) {
            return null;
        } else {
            code = code.trim();
        }
        mysqlJdbcDim.getConnection();
        String sql = String.format("select code, pk, name, memo from %s where code = '%s'", tableName, code);
        DimTable dimTable = new DimTable();
        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {
                dimTable.setCode(code);
                dimTable.setPk(resultSet.getString(2));
                dimTable.setName(resultSet.getString(3));
                dimTable.setMemo(resultSet.getString(4));
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            mysqlJdbcDim.close(null, null, resultSet);
        }
        return dimTable;
    }
}
