package com.gmei.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/**
 * Created by allen on 2017/4/6.
 */
public class SimpleCacheService<K, V> extends CacheServiceAbstract<K, V> implements Serializable {

    private Cache<K, V> cache = null;
    private int maximumSize = 1000;
    private int expireAfterWrite = 1;

    public SimpleCacheService() {
        createCache();
    }

    public SimpleCacheService(int maximumSize, int expireAfterWrite) {

        this.maximumSize = maximumSize;
        this.expireAfterWrite = expireAfterWrite;
        createCache();
    }

    public void createCache() {
        cache = CacheBuilder
                .newBuilder()
                .maximumSize(maximumSize)
                .expireAfterWrite(expireAfterWrite, TimeUnit.HOURS)
                .build();
    }


    @Override
    public V getValue(final K key, final Callable<V> callable) {
        if(key == null) {
            return null;
        }
        try {
            return cache.get(key, callable);
        } catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<K, V> asMap(Cache cache) {
        Map cacheMap = cache.asMap();
        return cacheMap;
    }


    @Override
    public void putValue(K key, V value) {
        cache.put(key, value);
    }

    @Override
    public void invalidate(Object key) {
        cache.invalidate(key);
    }

    @Override
    public void clearCache(){
        this.cache.invalidateAll();
    }

    @Override
    public Long cacheSize() {
        return this.cache.size();
    }

    @Override
    public void putValues(Map<K, V> map) {
        cache.putAll(map);
//        cache = new CacheLoader() {
//            @Override
//            public Object load(Object o) throws Exception {
//                for (Object o : objects) {
//                    cache.put(o.getcode(), value);
//                }
//                return o;
//            }
//        };
//                new CacheLoader<Long, Optional<Object>>() {
//
//            @Override
//            public Optional<Object> load(Long storeId) throws Exception {
//                Object s = null;
//
//                List<Object> results = null;
//                if (results != null && results.size() > 0) {
//                    s =  results.get(0);
//                }
//
//                return Optional.ofNullable(s);
//            }
//
//        }
    }

    public Cache<K, V> getCache() {
        return cache;
    }
//    public void putValues(Map<K, V> map) {
//
//    }
}
