package com.gmei.function;

import com.gmei.bean.bl.BlPreciseExposureBean;
import org.apache.flink.api.common.functions.FilterFunction;

import java.util.Arrays;
import java.util.List;

/**
 * ClassName: BlPreciseExposureFilterFunction
 * Function:
 * Reason: BL层数据筛选器
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureFilterFunction implements FilterFunction<BlPreciseExposureBean> {
    @Override
    public boolean filter(BlPreciseExposureBean blPreciseExposureBean) throws Exception {
        String app_code = blPreciseExposureBean.getApp_code();
        String is_exposure = blPreciseExposureBean.getIs_exposure();
        String is_popup = blPreciseExposureBean.getIs_popup();
        String app_version = blPreciseExposureBean.getApp_version();
        String page_code = blPreciseExposureBean.getPage_code();
        Boolean flag = true;
        //清洗掉app_code不等于gengmei_user与is_exposure不等于1的
        //1.5 Home页精准曝光触发两次
        //问题描述：在7.7.70','7.7.71','7.7.72','7.7.75','7.7.76','7.8.0','7.8.1' (7.7.70--7.9.0)版本中的首页精准曝光会触发两次，经确认，需要去除page_name='home'
        //1.6 品类聚合页的精准曝光问题
        //问题描述：品类聚合页的精准曝光没做，但是数据中却有精准曝光、而且有问题，因此过滤掉，目前还不能确定什么版本可以解决，先暂时根据page_name过滤掉page_name='category'
        //1.15 当首页精准曝光是通过弹窗触发或者点击push的时候，会有额外的精准曝光数据，需要去掉这部分数据
        List<String> app_version_list = Arrays.asList("7.7.70","7.7.71","7.7.72","7.7.75","7.7.76","7.8.0","7.8.1");
        String[] version = app_version.split("\\.");
        if(version.length != 3) {
            flag = false;
        } else if(!"gengmei_user".equals(app_code) || !"1".equals(is_exposure)) {
            flag = false;
        } else if(app_version_list.contains(app_version) && "home".equals(page_code)) {
            flag = false;
        } else if("category".equals(page_code) && "7".equals(version[0]) && Integer.parseInt(version[1]) < 14 ) {
            flag = false;
        } else if("home".equals(page_code) && "1".equals(is_popup)) {
            flag = false;
        }
        return flag;
    }
}
