package com.gmei.jdbc;

import java.sql.*;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * ClassName: MysqlJdbcBl
 * Function:
 * Reason: 单例模式的数据下发jdbc工具
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MysqlJdbcBl {
    private volatile static MysqlJdbcBl mysqlJdbcBl = null;

//    private static String driver = "com.mysql.cj.jdbc.Driver";
//    public static String url = "jdbc:mysql://localhost:3306/zhengxing?useSSL=false&serverTimezone=UTC";
//    //?useUnicode=true&characterEncoding=utf8&serverTimezone=GMT&allowMultiQueries=true&useSSL=false
//    public static String username = "jayden";
//    public static String password = "jayden548493";

//    private String driver = "com.mysql.jdbc.Driver";
//    private String url = "jdbc:mysql://172.22.30.12:3506/test?useUnicode=true&characterEncoding=UTF-8";//设置连接字符串
//    //rewriteBatchedStatements=true
//    private String username = "work";
//    private String password = "zJnxVEhyyxeC7ciqxdMITVyWqOFc2mew";

    private String driver = "com.mysql.jdbc.Driver";
    private String url;
    private Connection conn;

    private MysqlJdbcBl(String url) {
        this.url = url;
    }

    public static MysqlJdbcBl getInstance(String url) {
        if (mysqlJdbcBl == null) {
            synchronized (MysqlJdbcBl.class) {
                if(mysqlJdbcBl == null) {
                    mysqlJdbcBl = new MysqlJdbcBl(url);
                }
            }
        }
        return mysqlJdbcBl;
    }

    public Connection getConnection() {
        try {
            Class.forName(driver);
            if(conn == null || conn.isClosed()) {
//                conn = DriverManager.getConnection("jdbc:mysql://localhost:3306/zhengxing?useSSL=false&serverTimezone=UTC", "jayden", "jayden548943");
//                conn = DriverManager.getConnection(url, username, password);
                conn = DriverManager.getConnection(url);
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public void update(String sql, List<Object> params) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            if (params != null && params.size() > 0) {
                for (int i = 0; i < params.size(); i++) {
                    ps.setObject(i + 1, params.get(i));
                }
            }
            int resultNum = ps.executeUpdate();
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            ps.close();
        }
//        System.out.println(printRealSql(sql, params).replaceAll("(\\s+|\\\\n)", ""));
    }

    public void insert(String sql) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.executeUpdate(sql);
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            st.close();
        }
    }

    public String printRealSql(String sql, List<Object> params) {
        if(params == null || params.size() == 0) {
//            System.out.println("The SQL is------------>\n" + sql);
            return sql;
        }

        if (!match(sql, params)) {
            System.out.println("SQL 语句中的占位符与参数个数不匹配。SQL：" + sql);
            return null;
        }

        int cols = params.size();
//         values = params.toArray(index, count);
//        Object[] values = new Object[cols];
//        System.arraycopy(params, 0, values, 0, cols);
        Object[] values = params.toArray(new Object[cols]);
        for (int i = 0; i < cols; i++) {
            Object value = values[i];
            if (value instanceof Date) {
                values[i] = "'" + value + "'";
            } else if (value instanceof String) {
                values[i] = "'" + value + "'";
            } else if (value instanceof Boolean) {
                values[i] = (Boolean) value ? 1 : 0;
            }
        }

        String statement = String.format(sql.replaceAll("\\?", "%s"), values);

//        System.out.println("The SQL is------------>\n" + statement);
        return statement;
    }

    private static boolean match(String sql, List<Object> params) {
        if(params == null || params.size() == 0) return true; // 没有参数，完整输出

        Matcher m = Pattern.compile("(\\?)").matcher(sql);
        int count = 0;
        while (m.find()) {
            count++;
        }

        return count == params.size();
    }

//    public ResultSet query(String sql, List<Object> param) {
//        try {
//            ps = conn.prepareStatement(sql);
//
//            if (param != null && param.size() > 0) {
//                for (int i = 0; i < param.size(); i++) {
//                    ps.setObject(i + 1, param.get(i));
//                }
//            }
//            if(!ps.isClosed())
//                System.out.println("Succeeded connecting to the prepareStatement!");
//            rs = ps.executeQuery();
//        } catch (SQLException e) {
//            e.printStackTrace();
//        }
//        return rs;
//    }

    public ResultSet query(String sql) {
//        System.out.println(sql);
        if(conn == null){
            conn = getConnection();
        }
        ResultSet rs = null;
        Statement st = null;
        try {

            st = conn.createStatement();
            rs = st.executeQuery(sql);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public void close(Connection con, Statement st, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
            if (st != null) {
                try {
                    st.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
