package com.gmei.utils;

import java.lang.reflect.Field;

/**
 * ClassName: BeanReflectUtil
 * Function:
 * Reason: 类反射工具类
 * Date: 2019/12/5 下午3:54
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BeanReflectUtil {

    /**
    * Function: getFieldValue
    * Reason: 通过类反射获取属性值
    * Date: 2019/12/25 下午4:41
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public static <T> Object getFieldValue(T obj, String field) throws Exception {
        Class<?> claz = obj.getClass();
        Field f = null;
        Object fieldValue = null;

        Field[] fields = claz.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            if (fields[i].getName().equals(field)) {
                f = claz.getDeclaredField(field);
                f.setAccessible(true);
                fieldValue = f.get(obj);
            }
        }
        return fieldValue;
    }

    /**
    * Function: setFieldValue
    * Reason: 通过类反射设置属性值
    * Date: 2019/12/25 下午4:41
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public static <T> void setFieldValue(T obj, String field, Object value) {
        Class<?> claz = obj.getClass();
        Field f = null;
        try {
            Field[] fields = claz.getDeclaredFields();
            for (int i = 0; i < fields.length; i++) {
                if (fields[i].getName().equals(field)) {
                    f = claz.getDeclaredField(field);
                    f.setAccessible(true);
                    f.set(obj, value);
                }
            }
        } catch (Exception e) {
            e.getStackTrace();
        }
    }

    /**
    * Function: setNullValue
    * Reason: 通过类反射设置所有空字符串为NULL
    * Date: 2019/12/25 下午4:42
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public static <T> T setNullValue(T source) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        Field[] fields = source.getClass().getDeclaredFields();
        for (Field field : fields) {
            if (field.getGenericType().toString().equals("class java.lang.String")) {
                field.setAccessible(true);
                Object obj = field.get(source);
                if (obj != null && obj.equals("")) {
                    field.set(source, null);
                }
            }
        }
        return source;
    }
}
