package com.gmei.callable;

import com.gmei.bean.DeviceInfo;
import com.gmei.bean.StaticTable;
import com.gmei.utils.JDBCUtils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;

/**
 * ClassName: com.gmei.callable.DeviceCallable
 * Function: TODO ADD FUNCTION.
 * Reason: 查询设备信息
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class DeviceCallable implements Callable<DeviceInfo>{
    private String device_id;
    private Connection connection;
    private String today;
    private String tomorrow;

    public DeviceCallable(String device_id, Connection connection, String today, String tomorrow) {
        this.device_id = device_id;
        this.connection = connection;
        this.today = today;
        this.tomorrow = tomorrow;
    }

    @Override
    public DeviceInfo call() throws Exception {
        return findDevice(device_id,connection,today,tomorrow);
    }

    private DeviceInfo findDevice(String device_id, Connection connection, String today, String tomorrow) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(String.format("select " +
                        "(CASE WHEN TRIM(device_id) <> '' AND TRIM(device_id) <> '00000000-0000-0000-0000-000000000000' THEN TRIM(device_id) WHEN TRIM(idfv) = '' AND TRIM(device_id) = '00000000-0000-0000-0000-000000000000' THEN CONCAT('hive@', CAST(RAND() AS char)) ELSE TRIM(idfv) END) AS device_id," +
                        "IF(TRIM(platform) = 'iPhone', 'ios', TRIM(platform)) AS platform," +
                        "TRIM(version) AS version,TRIM(os_version) AS os_version," +
                        "TRIM(model) AS model,TRIM(screen) AS screen," +
                        "TRIM(channel) AS channel," +
                        "date_format(created_time,'%%Y-%%m-%%d %%H:%%i:%%s') as created_time, " +
                        "date_format(last_activity,'%%Y-%%m-%%d %%H:%%i:%%s') as last_activity " +
                        "from %s " +
                        "where (TRIM(device_id) <> '' OR TRIM(idfv) <> '') " +
                        "and date_format(created_time,'%%Y-%%m-%%d %%H:%%i:%%s') >= '%s' " +
                        "and date_format(created_time,'%%Y-%%m-%%d %%H:%%i:%%s') < '%s' " +
                        "and device_id = '%s' " +
                        "order by created_time, id limit 1",
                StaticTable.STATISTIC_DEVICE,
                today,
                tomorrow,
                device_id));
        DeviceInfo deviceInfo = new DeviceInfo();
        if(resultSet.next()){
            deviceInfo.setDevice_id(resultSet.getString(1));
            deviceInfo.setPlatform(resultSet.getString(2));
            deviceInfo.setVersion(resultSet.getString(3));
            deviceInfo.setOs_version(resultSet.getString(4));
            deviceInfo.setModel(resultSet.getString(5));
            deviceInfo.setScreen(resultSet.getString(6));
            deviceInfo.setChannel(resultSet.getString(7));
            deviceInfo.setCreated_time(resultSet.getString(8));
            deviceInfo.setLast_activity(resultSet.getString(9));
        }
        JDBCUtils.close(null,statement,resultSet);
        return deviceInfo;
    }
}
