package com.gmei.callable;

import com.gmei.bean.BackendDevice;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;

/**
 * ClassName: com.gmei.callable.DeviceUpdateCallable
 * Function: TODO ADD FUNCTION.
 * Reason: 查询设备增量表活跃设备信息
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class DeviceUpdateCallable implements Callable<BackendDevice>{
    private String device_id;
    private Connection connection;
    private String tableName;
    private String today;

    public DeviceUpdateCallable(String device_id, Connection connection,String tableName,String today) {
        this.device_id = device_id;
        this.connection = connection;
        this.tableName = tableName;
        this.today = today;
    }

    @Override
    public BackendDevice call() throws Exception {
        return findDeviceByDeviceId(device_id,connection);
    }

    private BackendDevice findDeviceByDeviceId(String device_id, Connection connection) throws SQLException {

        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(String.format("select device_id," +
                "first_visit_time_today," +
                "history_first_visit_time," +
                "first_user_id_today," +
                "user_id_time," +
                "history_first_user_id," +
                "first_city_id_today," +
                "city_id_time," +
                "history_first_city_id," +
                "first_channel_today," +
                "channel_time," +
                "history_first_channel," +
                "first_platform_today," +
                "platform_time," +
                "history_first_platform," +
                "first_os_version_today," +
                "os_version_time," +
                "history_firest_os_version," +
                "first_app_version_today," +
                "app_version_time," +
                "history_first_app_version," +
                "model," +
                "screen," +
                "is_doctor," +
                "date," +
                "history_user_id_time," +
                "history_city_id_time," +
                "history_channel_time," +
                "history_platform_time," +
                "history_os_version_time," +
                "history_app_version_time " +
                "from %s where device_id = '%s' and first_visit_time_today is not null and date <= '%s' order by date desc limit 1", tableName, device_id,today));

        BackendDevice backendDevice = new BackendDevice();
        if(resultSet.next()){
            backendDevice.setDevice_id(device_id);
            backendDevice.setFirst_visit_time_today(resultSet.getString(2));
            backendDevice.setHistory_first_visit_time(resultSet.getString(3));
            backendDevice.setFirst_user_id_today(resultSet.getString(4));
            backendDevice.setUser_id_time(resultSet.getString(5));
            backendDevice.setHistory_first_user_id(resultSet.getString(6));
            backendDevice.setFirst_city_id_today(resultSet.getString(7));
            backendDevice.setCity_id_time(resultSet.getString(8));
            backendDevice.setHistory_first_city_id(resultSet.getString(9));
            backendDevice.setFirst_channel_today(resultSet.getString(10));
            backendDevice.setChannel_time(resultSet.getString(11));
            backendDevice.setHistory_first_channel(resultSet.getString(12));
            backendDevice.setFirst_platform_today(resultSet.getString(13));
            backendDevice.setPlatform_time(resultSet.getString(14));
            backendDevice.setHistory_first_platform(resultSet.getString(15));
            backendDevice.setFirst_os_version_today(resultSet.getString(16));
            backendDevice.setOs_version_time(resultSet.getString(17));
            backendDevice.setHistory_firest_os_version(resultSet.getString(18));
            backendDevice.setFirst_app_version_today(resultSet.getString(19));
            backendDevice.setApp_verison_time(resultSet.getString(20));
            backendDevice.setHistory_first_app_version(resultSet.getString(21));
            backendDevice.setModel(resultSet.getString(22));
            backendDevice.setScreen(resultSet.getString(23));
            backendDevice.setIs_doctor(resultSet.getString(24));
            backendDevice.setDate(resultSet.getString(25));
            backendDevice.setHistory_user_id_time(resultSet.getString(26));
            backendDevice.setHistory_city_id_time(resultSet.getString(27));
            backendDevice.setHistory_channel_time(resultSet.getString(28));
            backendDevice.setHistory_platform_time(resultSet.getString(29));
            backendDevice.setHistory_os_version_time(resultSet.getString(30));
            backendDevice.setHistory_app_version_time(resultSet.getString(31));
        }

        return backendDevice;
    }
}
