package com.gmei.map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.FlinkServer;
import com.gmei.bean.BackendEtl;
import com.gmei.utils.StringUtils;
import org.apache.flink.api.common.functions.MapFunction;

/**
 * ClassName: com.gmei.map.GainValueMap
 * Function: TODO ADD FUNCTION.
 * Reason: 解析获取数据属性字段
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class GainValueMap implements MapFunction<String,BackendEtl> {
    @Override
    public BackendEtl map(String value) throws Exception {
        JSONObject jsonObject = JSON.parseObject(value);
        JSONObject sysObject = jsonObject.getJSONObject("SYS");
        JSONObject appObject = jsonObject.getJSONObject("APP");

        String time_str = jsonObject.get("TIME").toString();
        try {
            time_str = FlinkServer.dateTimeFormat.parseMillis(time_str) + "";
        } catch (IllegalArgumentException e) {
            time_str = FlinkServer.dateTimeNoMillisFormat.parseMillis(time_str) + "";
        }

        String action = "";
        String user_id = "";
        String city_id = "";
        String channel = "";
        String cl_id = "";
        String cl_type = "";
        String cl_idfv = "";
        String app_version = "";
        String cl_os_ver = "";
        if(!StringUtils.isObjectNull(sysObject)){
            action = StringUtils.changeNullTolength0(sysObject.get("action"));
            user_id = StringUtils.changeNullTolength0(sysObject.get("entry_user_id"));
            city_id = StringUtils.changeNullTolength0(sysObject.get("cl_city_id"));
            if("worldwide".equals(city_id) || "(null)".equals(city_id)){
                city_id = "";
            }
            channel = StringUtils.changeNullTolength0(sysObject.get("channel"));
            cl_id = StringUtils.changeNullTolength0(sysObject.get("cl_id"));
            cl_type = StringUtils.changeNullTolength0(sysObject.get("cl_type"));
            cl_idfv = StringUtils.changeNullTolength0(sysObject.get("cl_ios_idfv"));
            cl_os_ver = StringUtils.changeNullTolength0(sysObject.get("cl_os_ver"));
            app_version = StringUtils.changeNullTolength0(sysObject.get("cl_ver"));

            if (cl_id == "" && cl_idfv != "") {
                cl_id = cl_idfv;
            } else if (cl_id == "" && cl_idfv == "") {
                cl_id = null;
            }
        }

        String tracking_id = "";
        if(!StringUtils.isObjectNull(appObject)){
            tracking_id = StringUtils.changeNullTolength0(appObject.get("tracking_id"));
        }

        String log_id = StringUtils.changeNullTolength0(jsonObject.get("log_id"));

        BackendEtl backendEtl = new BackendEtl(time_str,
                action,
                user_id,
                city_id,
                channel,
                cl_id,
                cl_type,
                cl_idfv,
                app_version,
                tracking_id,
                log_id,
                cl_os_ver,
                "0");

        return backendEtl;
    }
}
