package com.gmei.utils;

import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;

/**
 * ClassName: com.gmei.utils.GmKafkaConsumer
 * Function: TODO ADD FUNCTION.
 * Reason: 定义kafka数据源，必须定制schama
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class GmKafkaConsumer {
    private String topic;
    private Properties prop;
    private FlinkKafkaConsumer flinkKafkaConsumer;

    public GmKafkaConsumer(String topic) {
        this.topic = topic;
        this.prop = new Properties();
    }

    public void setSource(DeserializationSchema<String> schema) throws ParseException {
        this.flinkKafkaConsumer = new FlinkKafkaConsumer<String>(topic,schema,this.prop);
    }

    public FlinkKafkaConsumer getSource(){
        return this.flinkKafkaConsumer;
    }

    public void setProp(String key,String value){
        prop.setProperty(key,value);
    }
}
