package com.gmei.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * ClassName: com.gmei.utils.StringUtils
 * Function: TODO ADD FUNCTION.
 * Reason: String工具类
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class StringUtils {
    /**
     * Function: TODO ADD FUNCTION.
     * Reason: 获得数据md5
     * Date: 2020-03-03 00:00:00
     *
     * @author sjxuwei
     * @since JDK 1.8
     */
    public static String getStringMd5(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] digest = md5.digest(bytes);
        StringBuffer hexValue = new StringBuffer();

        for (int i = 0; i < digest.length; i++){
            int val = ((int) digest[i]) & 0xff;
            if (val < 16)
                hexValue.append("0");
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    /**
     * Function: TODO ADD FUNCTION.
     * Reason: 判断对象是否为NULL
     * Date: 2020-03-03 00:00:00
     *
     * @author sjxuwei
     * @since JDK 1.8
     */
    public static boolean isObjectNull(Object object){
        return (object == null);
    }

    /**
     * Function: TODO ADD FUNCTION.
     * Reason: 将为NULL的对象转换为长度为0的字符串
     * Date: 2020-03-03 00:00:00
     *
     * @author sjxuwei
     * @since JDK 1.8
     */
    public static String changeNullTolength0(Object object){
        if(object == null){
            return  "";
        }else{
            return object.toString();
        }
    }

    /**
     * Function: TODO ADD FUNCTION.
     * Reason: 将为NULL的对象转换成double类型
     * Date: 2020-03-03 00:00:00
     *
     * @author sjxuwei
     * @since JDK 1.8
     */
    public static Double isNullToDouble(Object object){
        if(object == null){
            return 0.0;
        }else{
            if(object.toString().length() <= 0) {
                return 0.0;
            }else{
              return  Double.parseDouble(object.toString());
            }
        }
    }

    /**
     * Function: TODO ADD FUNCTION.
     * Reason: 从参数中获取第一个不为NULL并且长度大于0的字符串，否则返回长度为0的字符串
     * Date: 2020-03-03 00:00:00
     *
     * @author sjxuwei
     * @since JDK 1.8
     */
    public static String getNotNull(String... str){
        for(String s : str){
            if(s != null && s.length() > 0){
                return s;
            }
        }
        return "";
    }

    /**
     * Function: TODO ADD FUNCTION.
     * Reason: 如果参数1的长度为0则取第二个参数的值
     * Date: 2020-03-03 00:00:00
     *
     * @author sjxuwei
     * @since JDK 1.8
     */
    public static String changeLength0toOther(String str1,String str2){
        if(str1.length() == 0){
            return str2;
        }else{
            return str1;
        }
    }

}

