package com.gmei.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.bean.bl.BlPreciseExposureParamsExposureCardsBean;
import com.gmei.jdbc.MysqlJdbcSink;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName: BlPreciseExposureDao
 * Function:
 * Reason: bl_et_mg_preciseexposure_inc_d_rt数据下发操作类
 * Date: 2019/12/19 上午11:35
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureDao {
    private MysqlJdbcSink mysqlJdbcSink;
    private String sql;
    private String sinkJdbcUrl;
    private String sinkTableName;

    public BlPreciseExposureDao(String sinkJdbcUrl, String sinkTableName) {
        this.sinkJdbcUrl = sinkJdbcUrl;
        this.sinkTableName = sinkTableName;
        this.mysqlJdbcSink = MysqlJdbcSink.getInstance(sinkJdbcUrl);
    }

    /**
    * Function: insertBlPreciseExposure
    * Reason: 向表中插入数据
    * Date: 2019/12/25 下午5:38
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public void insertBlPreciseExposure(BlPreciseExposureBean blPreciseExposureBean) throws Exception {
        sql = "insert into " + sinkTableName + "\n" +
                "  (json,\n" +
                "   gm_nginx_timestamp,\n" +
                "   create_timestamp,\n" +
                "   user_id,\n" +
                "   action,\n" +
                "   down_loading_times,\n" +
                "   down_slide_times,\n" +
                "   up_loading_times,\n" +
                "   up_slide_times,\n" +
                "   page_code,\n" +
                "   tab_name,\n" +
                "   business_id,\n" +
                "   referrer_code,\n" +
                "   referrer_id,\n" +
                "   exposure_cards,\n" +
                "   is_exposure,\n" +
                "   is_popup,\n" +
                "   filter,\n" +
                "   query,\n" +
                "   app_grey_type,\n" +
                "   app_channel,\n" +
                "   app_version,\n" +
                "   app_current_city_id,\n" +
                "   app_code,\n" +
                "   device_os_type,\n" +
                "   device_model,\n" +
                "   device_id,\n" +
                "   device_android_id,\n" +
                "   device_idfv,\n" +
                "   gm_nginx_time_date,\n" +
                "   gm_nginx_time_day,\n" +
                "   create_time_date,\n" +
                "   create_time_day)\n" +
                "values\n" +
                "  (?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?)";

        List<Object> params = new ArrayList<Object>();
        String json = blPreciseExposureBean.getJson();
//        Clob clob = connection.createClob();
//        clob.setString(1, json);
        params.add(json);
        params.add(blPreciseExposureBean.getGm_nginx_timestamp());
        params.add(blPreciseExposureBean.getCreate_timestamp());
        params.add(blPreciseExposureBean.getUser_id());
        params.add(blPreciseExposureBean.getAction());
        params.add(blPreciseExposureBean.getDown_loading_times());
        params.add(blPreciseExposureBean.getDown_slide_times());
        params.add(blPreciseExposureBean.getUp_loading_times());
        params.add(blPreciseExposureBean.getUp_slide_times());
        params.add(blPreciseExposureBean.getPage_code());
        params.add(blPreciseExposureBean.getTab_name());
        params.add(blPreciseExposureBean.getBusiness_id());
        params.add(blPreciseExposureBean.getReferrer_code());
        params.add(blPreciseExposureBean.getReferrer_id());
        ArrayList<BlPreciseExposureParamsExposureCardsBean> blPreciseExposureCardsBeans= blPreciseExposureBean.getExposure_cards();
        JSONArray jsonArrayCardsBeans= JSONArray.parseArray(JSON.toJSONString(blPreciseExposureCardsBeans));
        params.add(jsonArrayCardsBeans.toString());
        params.add(blPreciseExposureBean.getIs_exposure());
        params.add(blPreciseExposureBean.getIs_popup());
        params.add(blPreciseExposureBean.getFilter());
        params.add(blPreciseExposureBean.getQuery());
        params.add(blPreciseExposureBean.getApp_grey_type());
        params.add(blPreciseExposureBean.getApp_channel());
        params.add(blPreciseExposureBean.getApp_version());
        params.add(blPreciseExposureBean.getApp_current_city_id());
        params.add(blPreciseExposureBean.getApp_code());
        params.add(blPreciseExposureBean.getDevice_os_type());
        params.add(blPreciseExposureBean.getDevice_model());
        params.add(blPreciseExposureBean.getDevice_id());
        params.add(blPreciseExposureBean.getDevice_android_id());
        params.add(blPreciseExposureBean.getDevice_idfv());
        params.add(blPreciseExposureBean.getGm_nginx_time_date());
        params.add(blPreciseExposureBean.getGm_nginx_time_day());
        params.add(blPreciseExposureBean.getCreate_time_date());
        params.add(blPreciseExposureBean.getCreate_time_day());
//        System.out.println(params.toString());
        mysqlJdbcSink.update(sql, params);
    }
}
