package com.gmei.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.bean.bl.BlPreciseExposureParamsExposureCardsBean;
import com.gmei.utils.BeanReflectUtil;
import com.gmei.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.MapFunction;

import java.util.ArrayList;


/**
 * ClassName: BlPreciseExposureMapFunction
 * Function:
 * Reason: BL层数据清洗转换器（一对一）
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureMapFunction implements MapFunction<String, BlPreciseExposureBean> {
    @Override
    public BlPreciseExposureBean map(String string) throws Exception {
        BlPreciseExposureBean blPreciseExposureBean = new BlPreciseExposureBean();
        JSONObject app = null;
        String gm_nginx_timestamp = null;
        String create_timestamp = null;
        String user_id = null;
        String action = null;

        String app_grey_type = null;
        String app_channel = null;
        String app_version = null;
        String app_current_city_id = null;
        String app_code = null;

        JSONObject params = null;
        Integer down_loading_times = null;
        Integer down_slide_times = null;
        Integer up_loading_times = null;
        Integer up_slide_times = null;
        String page_code = null;
        String tab_name = null;
        String business_id = null;
        String referrer_code = null;
        String referrer_id = null;
        String is_exposure = null;
        String is_popup = null;
        String filter = null;
        String query = null;
        JSONArray jsonArrayExposureCards = null;

        JSONObject device = null;
        String device_os_type = null;
        String device_model = null;
        String device_id = null;
        String device_idfv = null;
        String device_android_id = null;

        String gm_nginx_time_date = null;
        String gm_nginx_time_day = null;
        String create_time_date = null;
        String create_time_day = null;

        //去除掉json中的回车、换行、制表、空格
        String jsonString = string.replaceAll("\\s+|\\\\n", "");

        JSONObject jsonObject = JSON.parseObject(jsonString);

        //一级别JSON
        app = jsonObject.getJSONObject("app");
        gm_nginx_timestamp = String.valueOf(jsonObject.get("gm_nginx_timestamp"));
        create_timestamp = String.valueOf(jsonObject.get("create_at"));
        user_id = jsonObject.getString("user_id");
        action = jsonObject.getString("type");

        //二级别JSON
        //APP
        if (app != null) {
            app_grey_type = app.getString("grey_type");
            app_channel = app.getString("channel");
            app_version = app.getString("version");
            app_current_city_id = app.getString("current_city_id");
            app_code = app.getString("name");
        }
        //1.2 absolute_position参数类型不完整
        //问题描述：在'7.7.35', '7.7.36', '7.7.40'params的absolute_position缺少左边引号
        String paramsString = String.valueOf(jsonObject.get("params"));
        if("7.7.35".equals(app_version) || "7.7.36".equals(app_version) || "7.7.40".equals(app_version)) {
            paramsString = paramsString.replace("absolute_position","\\\"absolute_position");
        }

        //PARAMS
        params =  JSON.parseObject(paramsString);
        if (params != null) {
            down_loading_times = params.getInteger("down_loading_times");
            down_slide_times = params.getInteger("down_slide_times");
            up_loading_times = params.getInteger("up_loading_times");
            up_slide_times = params.getInteger("up_slide_times");
            page_code = params.getString("page_name");
            tab_name = params.getString("tab_name");
            business_id = params.getString("business_id");
            referrer_code = params.getString("referrer");
            referrer_id = params.getString("referrer_id");
            is_exposure = params.getString("is_exposure");
            is_popup = params.getString("is_popup");
            filter = params.getString("filter");
            query = params.getString("query");
        }
        //1.4 初版精准曝光格式错误
        //问题描述：在'7.7.60'版本中美购页卡片的card_id和transaction_type这两个参数是数组的形式
//        ArrayList<BlPreciseExposureParamsExposureCardsBean> exposure_cards =(ArrayList<BlPreciseExposureParamsExposureCardsBean>)JSONArray.parseArray(params.getJSONArray("exposure_cards").toString(), BlPreciseExposureParamsExposureCardsBean.class);
        ArrayList<BlPreciseExposureParamsExposureCardsBean> exposure_cards = new ArrayList<>();
        try {
            jsonArrayExposureCards = JSONArray.parseArray(params.getJSONArray("exposure_cards").toString());
            for (int i = 0; i < jsonArrayExposureCards.size(); i++) {
                JSONObject jsonCard = jsonArrayExposureCards.getJSONObject(i);
                String card_id = jsonCard.getString("card_id");
                String transaction_type = jsonCard.getString("transaction_type");
                String card_content_type = jsonCard.getString("card_content_type");
                String card_type = jsonCard.getString("card_type");
                String card_name = jsonCard.getString("card_name");
                String target_name = jsonCard.getString("target_name");
                String is_cpc = jsonCard.getString("is_cpc");
                String cpc_referer = jsonCard.getString("cpc_referer");
                String absolute_posttion = jsonCard.getString("absolute_position");
                String relative_position = jsonCard.getString("relative_position");
//                if("service".equals(card_content_type) && "7.7.60".equals(app_version)) {
                if(StringUtils.startsWithIgnoreCase(card_id, "[") && StringUtils.endsWithIgnoreCase(card_id, "]")) {
                    JSONArray card_id_list = JSONArray.parseArray(card_id);
                    JSONArray transaction_type_list = null;
                    if(StringUtils.startsWithIgnoreCase(transaction_type, "[") && StringUtils.endsWithIgnoreCase(transaction_type, "]")) {
                        transaction_type_list = JSONArray.parseArray(transaction_type);
                    }
                    for (int j = 0; j < card_id_list.size(); j++) {
                        BlPreciseExposureParamsExposureCardsBean cardsBean = new BlPreciseExposureParamsExposureCardsBean();
                        cardsBean.setCard_id(card_id_list.getString(j));
                        try {
                            cardsBean.setTransaction_type(transaction_type_list.getString(j));
                        } catch (Exception e) {
                            cardsBean.setTransaction_type(null);
                        }
                        cardsBean.setCard_content_type(card_content_type);
                        cardsBean.setCard_type(card_type);
                        cardsBean.setCard_name(card_name);
                        cardsBean.setTarget_name(target_name);
                        cardsBean.setIs_cpc(is_cpc);
                        cardsBean.setCpc_referer(cpc_referer);
                        cardsBean.setAbsolute_position(absolute_posttion);
                        cardsBean.setRelative_position(relative_position);
                        exposure_cards.add(cardsBean);
                    }
                } else {
                    BlPreciseExposureParamsExposureCardsBean cardsBean = new BlPreciseExposureParamsExposureCardsBean();
                    cardsBean.setCard_id(card_id);
                    cardsBean.setTransaction_type(transaction_type);
                    cardsBean.setCard_content_type(card_content_type);
                    cardsBean.setCard_type(card_type);
                    cardsBean.setCard_name(card_name);
                    cardsBean.setTarget_name(target_name);
                    cardsBean.setIs_cpc(is_cpc);
                    cardsBean.setCpc_referer(cpc_referer);
                    cardsBean.setAbsolute_position(absolute_posttion);
                    cardsBean.setRelative_position(relative_position);
//                    BlPreciseExposureParamsExposureCardsBean cardsBean = JSON.toJavaObject(jsonCard, BlPreciseExposureParamsExposureCardsBean.class);
                    exposure_cards.add(cardsBean);
                }
            }
        } catch (Exception e) {
//            System.out.println(JSON.parseObject(params.getString("exposure_cards")).toString());
        }

        //DEVICE
        device = jsonObject.getJSONObject("device");
        if (device != null) {
            device_os_type = device.getString("device_type");
            device_model = device.getString("model");
            device_id = device.getString("device_id");
            device_idfv = device.getString("idfv");
            device_android_id = device.getString("android_device_id");
        }

        //1.1 ios系统精准曝光埋点channel字段
        //问题描述：ios系统精准曝光埋点channel字段AppStore应该修改为App Store
        if("AppStore".equals(app_channel)) {
            app_channel = "App Store";
        }

        //日志时间处理
        gm_nginx_time_date = DateUtil.timestampFormat(gm_nginx_timestamp, DateUtil.DateType.SECOND);
        gm_nginx_time_day = DateUtil.timestampFormat(gm_nginx_timestamp, DateUtil.DateType.DAY);
        create_time_date = DateUtil.timestampFormat(create_timestamp, DateUtil.DateType.SECOND);
        create_time_day = DateUtil.timestampFormat(create_timestamp, DateUtil.DateType.DAY);

        //1.7 result_status参数位置问题(未处理)
        //问题描述：搜索结果百科（search_result_wiki)和搜索结果美购（search_result_welfare）的result_status埋点埋在exposure_data里面了为了都获得该参数值，因此需要从两处拿取，默认先取exposure_data里的result_satus字段值（数据中发现不只是这两个页面）search_result_diary、search_result_doctor、search_result_hospital也存在

        //1.9 搜索结果页tab_name参数不该存在
        //问题描述:在搜索结果页出现tab_name参数，参数值和page_name一样，在点击的时候页面有跳转，因此，不应该有tab_name参数
        if (StringUtils.containsIgnoreCase(page_code, "search_result")) {
            tab_name = null;
        }

        blPreciseExposureBean.setJson(jsonString);
        blPreciseExposureBean.setGm_nginx_timestamp(gm_nginx_timestamp);
        blPreciseExposureBean.setCreate_timestamp(create_timestamp);
        blPreciseExposureBean.setUser_id(user_id);
        blPreciseExposureBean.setAction(action);
        blPreciseExposureBean.setApp_grey_type(app_grey_type);
        blPreciseExposureBean.setApp_channel(app_channel);
        blPreciseExposureBean.setApp_version(app_version);
        blPreciseExposureBean.setApp_current_city_id(app_current_city_id);
        blPreciseExposureBean.setApp_code(app_code);
        blPreciseExposureBean.setDown_loading_times(down_loading_times);
        blPreciseExposureBean.setDown_slide_times(down_slide_times);
        blPreciseExposureBean.setUp_loading_times(up_loading_times);
        blPreciseExposureBean.setUp_slide_times(up_slide_times);
        blPreciseExposureBean.setPage_code(page_code);
        blPreciseExposureBean.setTab_name(tab_name);
        blPreciseExposureBean.setBusiness_id(business_id);
        blPreciseExposureBean.setReferrer_code(referrer_code);
        blPreciseExposureBean.setReferrer_id(referrer_id);
        blPreciseExposureBean.setExposure_cards(exposure_cards);
        blPreciseExposureBean.setIs_exposure(is_exposure);
        blPreciseExposureBean.setIs_popup(is_popup);
        blPreciseExposureBean.setFilter(filter);
        blPreciseExposureBean.setQuery(query);
        blPreciseExposureBean.setDevice_os_type(device_os_type);
        blPreciseExposureBean.setDevice_model(device_model);
        blPreciseExposureBean.setDevice_id(device_id != null && device_id !="" ? device_id : device_idfv);
        blPreciseExposureBean.setDevice_android_id(device_android_id);
        blPreciseExposureBean.setDevice_idfv(device_idfv);
        blPreciseExposureBean.setGm_nginx_time_date(gm_nginx_time_date);
        blPreciseExposureBean.setGm_nginx_time_day(gm_nginx_time_day);
        blPreciseExposureBean.setCreate_time_date(create_time_date);
        blPreciseExposureBean.setCreate_time_day(create_time_day);
        return BeanReflectUtil.setNullValue(blPreciseExposureBean);
    }
}
