package com.gmei.function;

import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.utils.DateUtil;
import com.gmei.utils.HyperLogLog;
import net.agkn.hll.HLL;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ClassName: HyperLogLogFunction
 * Function: TODO ADD FUNCTION.
 * Reason: TODO ADD REASON.
 * Date: 2020/1/13 下午7:16
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class HyperLogLogFunction extends KeyedProcessFunction<String, BlPreciseExposureBean, BlPreciseExposureBean> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperLogLogFunction.class);
    private static final int HLL_CARDINAL_THRESHOLD = 3000000;
    private static final double HLL_FALSE_POSITIVE_RATE = 0.01; //误差
    private volatile HyperLogLog blPreciseExposureBeanHLL;
    private ValueState<Long> hllState;
    private ValueStateDescriptor<Long> hllStateDescriptor;

    @Override
    public void onTimer(long timestamp, OnTimerContext ctx, Collector<BlPreciseExposureBean> out) throws Exception {
        super.onTimer(timestamp, ctx, out);
        hllState.clear();
        long s = System.currentTimeMillis();
        blPreciseExposureBeanHLL = new HyperLogLog(HLL_FALSE_POSITIVE_RATE);
        long e = System.currentTimeMillis();
        LOGGER.info("Timer triggered & resetted HyperLogLog, time cost: " + (e - s));
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        blPreciseExposureBeanHLL = new HyperLogLog(HLL_FALSE_POSITIVE_RATE);
        hllStateDescriptor = new ValueStateDescriptor("hll", Types.OBJECT_ARRAY(Types.LONG));
        hllState = getRuntimeContext().getState(hllStateDescriptor);
    }

    @Override
    public void close() throws Exception {
        super.close();
        blPreciseExposureBeanHLL = null;
    }

    @Override
    public void processElement(BlPreciseExposureBean blPreciseExposureBean, Context context, Collector<BlPreciseExposureBean> collector) throws Exception {
        blPreciseExposureBeanHLL.offer(blPreciseExposureBean.getJson());
        Long countDistinct = blPreciseExposureBeanHLL.cardinality();
        Long hllStateValue = this.hllState.value();
        if(!countDistinct.equals(this.hllState.value())) {
            hllState.update(blPreciseExposureBeanHLL.cardinality());
            collector.collect(blPreciseExposureBean);
        }
        context.timerService().registerProcessingTimeTimer(DateUtil.tomorrowZeroTimestampMs(Double.valueOf(blPreciseExposureBean.getGm_nginx_timestamp()).longValue() * 1000, 8) + 1);
    }
}
