package com.gmei.function;

import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.utils.DateUtil;
import net.agkn.hll.HLL;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.hashing.MurmurHash3;

/**
 * ClassName: HyperLogLogFunction
 * Function: TODO ADD FUNCTION.
 * Reason: TODO ADD REASON.
 * Date: 2020/1/13 下午7:16
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class HyperLogLogFunction2 extends KeyedProcessFunction<String, BlPreciseExposureBean, BlPreciseExposureBean> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperLogLogFunction2.class);
    private static final int HLL_CARDINAL_THRESHOLD = 3000000;
    private static final double HLL_FALSE_POSITIVE_RATE = 0.01; //误差
//    private volatile HyperLogLog blPreciseExposureBeanHLL;
    private ValueState<Byte[]> hllState;
    private volatile HLL blPreciseExposureBeanHLL;
    private ValueStateDescriptor<Byte[]> hllStateDescriptor;

    @Override
    public void onTimer(long timestamp, OnTimerContext ctx, Collector<BlPreciseExposureBean> out) throws Exception {
        super.onTimer(timestamp, ctx, out);
        hllState.clear();
        long s = System.currentTimeMillis();
//        blPreciseExposureBeanHLL = new HyperLogLog(HLL_FALSE_POSITIVE_RATE);
        long e = System.currentTimeMillis();
        LOGGER.info("Timer triggered & resetted HyperLogLog, time cost: " + (e - s));
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
//        blPreciseExposureBeanHLL = new HyperLogLog(HLL_FALSE_POSITIVE_RATE);
        blPreciseExposureBeanHLL = new HLL(14, 5);
        hllStateDescriptor = new ValueStateDescriptor("hll", Types.OBJECT_ARRAY(Types.BYTE));
        hllState = getRuntimeContext().getState(hllStateDescriptor);
    }

    @Override
    public void close() throws Exception {
        super.close();
        blPreciseExposureBeanHLL.clear();
    }

    @Override
    public void processElement(BlPreciseExposureBean blPreciseExposureBean, Context context, Collector<BlPreciseExposureBean> collector) throws Exception {
        HLL hll = null;
        if (this.hllState.value() == null) {
            hll = new HLL(14, 5);
        } else {
            hll = HLL.fromBytes(ArrayUtils.toPrimitive(hllState.value()));
//            hll.addRaw(blPreciseExposureBean.getJson());
        }
        hllState.update(ArrayUtils.toObject(hll.toBytes()));

        if(hll.cardinality() != blPreciseExposureBeanHLL.cardinality()) {
            collector.collect(blPreciseExposureBean);
        }
        context.timerService().registerProcessingTimeTimer(DateUtil.tomorrowZeroTimestampMs(Double.valueOf(blPreciseExposureBean.getGm_nginx_timestamp()).longValue() * 1000, 8) + 1);
    }
}
