package com.gmei.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ClassName: DateUtil
 * Function:
 * Reason: 日期格式工具类
 * Date: 2019/12/17 下午4:51
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DateUtil {

    static SimpleDateFormat secDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static SimpleDateFormat dayDate = new SimpleDateFormat("yyyyMMdd");

    public enum DateType {
        DAY,
        SECOND;
    }

    /**
    * Function: timestampFormat.
     * DAY:yyyyMMdd
     * SECOND:yyyy-MM-dd HH:mm:ss
    * Reason: timestamp时间戳格式化.
    * Date: 2019/12/25 下午4:43
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public static String timestampFormat(String timestamp, DateType type) {
        Double timestampDouble = Double.parseDouble(timestamp);
        Long timestampLong = new Double(timestampDouble * 1000).longValue();
        Date date= new Date(timestampLong);
        switch (type) {
            case DAY:
                return dayDate.format(date);
            case SECOND:
                return secDate.format(date);
            default:
                return null;
        }
    }

    public static long changeDateToLong(String time, SimpleDateFormat simpleDateFormat) throws ParseException {
        return simpleDateFormat.parse(time).getTime();
    }

    // 根据当前时间戳获取第二天0时0分0秒的时间戳
    public static long tomorrowZeroTimestampMs(long now, int timeZone) {
        return now - (now + timeZone * 3600000) % 86400000 + 86400000;
    }
}
