package com.gmei.cache;

import java.util.Map;
import java.util.concurrent.Callable;

/**
 * ClassName: CacheServiceAbstract
 * Function:
 * Reason: 缓存抽象类
 * Date: 2019/12/10 下午7:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public abstract class CacheServiceAbstract<K, V> {

    abstract V getValue(K key, Callable<V> callable);

//    abstract V getValue(K key, Callable<Optional<V>> callable);

    abstract void clearCache();

    abstract Long cacheSize();

    abstract void putValue(K key, V value);

    abstract void invalidate(Object key);

//    abstract void putValues(ArrayList<V> ts);

    abstract void putValues(Map<K, V> map);
}
