package com.gmei.cache;

import com.gmei.bean.dim.DimCardContentType;
import com.gmei.jdbc.MysqlJdbcDim;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

/**
 * ClassName: DimCardContentTypeDao
 * Function:
 * Reason: dim_card_content_type卡片内容类型数据库操作类
 * Date: 2019/12/10 下午7:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DimCardContentTypeDao {

    private MysqlJdbcDim mysqlJdbcDim;
    private ResultSet resultSet;
    private String sql;
    private String dimJdbcUrl;

    public DimCardContentTypeDao() {
    }

    public DimCardContentTypeDao(String dimJdbcUrl) {
        this.dimJdbcUrl = dimJdbcUrl;
        this.mysqlJdbcDim =  MysqlJdbcDim.getInstance(dimJdbcUrl);
    }

    /**
    * Function: findAllDimCardContentType
    * Reason: 查询所有卡片内容类型信息
    * Date: 2019/12/25 下午5:32
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList<DimCardContentType> findAllDimCardContentType(String tableName) {
        sql = String.format(
                "select code, pk, name, memo, new_code" +
                "  from %s", tableName);
        ArrayList<DimCardContentType> dimCardContentTypeList = new ArrayList<>();
        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {
                DimCardContentType dimCardContentType = new DimCardContentType();
                dimCardContentType.setCode(resultSet.getString(1));
                dimCardContentType.setPk(resultSet.getString(2));
                dimCardContentType.setName(resultSet.getString(3));
                dimCardContentType.setMemo(resultSet.getString(4));
                dimCardContentType.setNew_code(resultSet.getString(5));
                dimCardContentTypeList.add(dimCardContentType);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            try {
                resultSet.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return dimCardContentTypeList;
    }

    /**
    * Function: findDimCardContentTypeByCode
    * Reason: 通过卡片内容类型编码查询信息
    * Date: 2019/12/25 下午5:34
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public DimCardContentType findDimCardContentTypeByCode(String tableName, String code){
        if (code == null || code.trim().length() == 0) {
            return null;
        } else {
            code = code.trim();
        }
        String sql = String.format(
                "select code, pk, name, memo, new_code " +
                "  from %s " +
                " where code = '%s'", tableName, code);
        DimCardContentType dimCardContentType = new DimCardContentType();
        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {
                dimCardContentType.setCode(code);
                dimCardContentType.setPk(resultSet.getString(2));
                dimCardContentType.setName(resultSet.getString(3));
                dimCardContentType.setMemo(resultSet.getString(4));
                dimCardContentType.setNew_code(resultSet.getString(5));
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            mysqlJdbcDim.close(null, null, resultSet);
        }
        return dimCardContentType;
    }
}