package com.gmei.cache;

import com.gmei.bean.dim.DimCity;
import com.gmei.jdbc.MysqlJdbcDim;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

/**
 * ClassName: DimCityDao
 * Function:
 * Reason: dim_city城市码表数据库操作类
 * Date: 2019/12/10 下午7:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DimCityDao {

    private MysqlJdbcDim mysqlJdbcDim;
    private ResultSet resultSet;
    private String sql;
    private Connection conn;
    private String dimJdbcUrl;

    public DimCityDao() {
    }

    public DimCityDao(String dimJdbcUrl) {
        this.dimJdbcUrl = dimJdbcUrl;
        this.mysqlJdbcDim = MysqlJdbcDim.getInstance(dimJdbcUrl);
    }

    /**
     * Function: findDimCityByCode
     * Reason: 根据城市ID查询城市信息
     * Date: 2019/12/7 下午7:56
     *
     * @author liuzhe
     * @since JDK 1.8
     */
    public DimCity findDimCityByCode(String tableName, String code){
        if (code == null || code.trim().length() == 0) {
            return null;
        } else {
            code = code.trim();
        }

        mysqlJdbcDim.getConnection();
        String sql = String.format(
                "select code, pk, name, memo, " +
                        "       parent_province_code, parent_province_pk, parent_province_memo," +
                        "       parent_country_code, parent_country_pk, parent_country_name," +
                        "       parent_region_code, parent_region_pk, parent_region_name " +
                        "  from %s " +
                        " where code = '%s'", tableName, code);
//        ArrayList<DimCity> dimCityList = new ArrayList<>();
        DimCity dimCity = new DimCity();

        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {

                dimCity.setCode(code);
                dimCity.setPk(resultSet.getString(2));
                dimCity.setName(resultSet.getString(3));
                dimCity.setMemo(resultSet.getString(4));
                dimCity.setParent_province_code(resultSet.getString(5));
                dimCity.setParent_province_pk(resultSet.getString(6));
                dimCity.setParent_province_name(resultSet.getString(7));
                dimCity.setParent_country_code(resultSet.getString(8));
                dimCity.setParent_country_pk(resultSet.getString(9));
                dimCity.setParent_country_name(resultSet.getString(10));
                dimCity.setParent_region_code(resultSet.getString(11));
                dimCity.setParent_region_pk(resultSet.getString(12));
                dimCity.setParent_region_name(resultSet.getString(13));
//                dimCityList.add(dimCity);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            mysqlJdbcDim.close(null, null, resultSet);
        }
        return dimCity;
    }

    /**
     * Function: findDimCityByPk
     * Reason: 根据城市TAGID查询城市信息
     * Date: 2019/12/7 下午7:56
     *
     * @author liuzhe
     * @since JDK 1.8
     */
    public DimCity findDimCityByPk(String tableName, String pk){
        if (pk == null || pk.trim().length() == 0) {
            return null;
        }
        pk = pk.trim();
        mysqlJdbcDim.getConnection();
        String sql = String.format(
                "select code, pk, name, memo, " +
                "       parent_province_code, parent_province_pk, parent_province_memo," +
                "       parent_country_code, parent_country_pk, parent_country_name," +
                "       parent_region_code, parent_region_pk, parent_region_name " +
                "  from %s " +
                " where pk = '%s'", tableName, pk);
//        ArrayList<DimCity> dimCityList = new ArrayList<>();
        DimCity dimCity = new DimCity();
        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {

                dimCity.setCode(resultSet.getString(1));
                dimCity.setPk(pk);
                dimCity.setName(resultSet.getString(3));
                dimCity.setMemo(resultSet.getString(4));
                dimCity.setParent_province_code(resultSet.getString(5));
                dimCity.setParent_province_pk(resultSet.getString(6));
                dimCity.setParent_province_name(resultSet.getString(7));
                dimCity.setParent_country_code(resultSet.getString(8));
                dimCity.setParent_country_pk(resultSet.getString(9));
                dimCity.setParent_country_name(resultSet.getString(10));
                dimCity.setParent_region_code(resultSet.getString(11));
                dimCity.setParent_region_pk(resultSet.getString(12));
                dimCity.setParent_region_name(resultSet.getString(13));
//                dimCityList.add(dimCity);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            mysqlJdbcDim.close(conn, null, resultSet);
        }
        return dimCity;
    }

    /**
    * Function: findAllDimCity
    * Reason: 查询所有城市信息
    * Date: 2019/12/25 下午5:21
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList<DimCity> findAllDimCity(String tableName) {
        mysqlJdbcDim.getConnection();
        sql = String.format(
                "select code, pk, name, memo, " +
                "       parent_province_code, parent_province_pk, parent_province_memo," +
                "       parent_country_code, parent_country_pk, parent_country_name," +
                "       parent_region_code, parent_region_pk, parent_region_name " +
                "  from %s", tableName);
        ArrayList<DimCity> dimCityList = new ArrayList<>();
        resultSet = mysqlJdbcDim.query(sql);
        try {
            while (resultSet.next()) {
                DimCity dimCity = new DimCity();
                dimCity.setCode(resultSet.getString(1));
                dimCity.setPk(resultSet.getString(2));
                dimCity.setName(resultSet.getString(3));
                dimCity.setMemo(resultSet.getString(4));
                dimCity.setParent_province_code(resultSet.getString(5));
                dimCity.setParent_province_pk(resultSet.getString(6));
                dimCity.setParent_province_name(resultSet.getString(7));
                dimCity.setParent_country_code(resultSet.getString(8));
                dimCity.setParent_country_pk(resultSet.getString(9));
                dimCity.setParent_country_name(resultSet.getString(10));
                dimCity.setParent_region_code(resultSet.getString(11));
                dimCity.setParent_region_pk(resultSet.getString(12));
                dimCity.setParent_region_name(resultSet.getString(13));
                dimCityList.add(dimCity);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            try {
                resultSet.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return dimCityList;
    }
}
