package com.gmei.cache;

import com.gmei.bean.dim.DimCity;
import com.gmei.utils.DimTableList;

import java.util.concurrent.Callable;

/**
 * ClassName: DimTableCallable
 * Function:
 * Reason: 通用Dim码表多线程调用类
 * Date: 2019/12/6 下午9:05t
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DimTableCallable<V> implements Callable<V> {

    private String code;
    private String tableName;
    private String dimJdbcUrl;



    public DimTableCallable(String code, String tableName, String dimJdbcUrl) {
        this.code = code;
        this.tableName = tableName;
        this.dimJdbcUrl = dimJdbcUrl;
    }

    public DimTableCallable() {}

    @Override
    public V call() {
//        try {
            if(code == null) {
                switch(DimTableList.getDimTableByName(tableName)) {
                    case DIM_CITY:
                        DimCityDao dimCityDao = new DimCityDao(dimJdbcUrl);
                        return (V) dimCityDao.findAllDimCity(tableName);
                    case DIM_CARD_CONTENT_TYPE:
                        DimCardContentTypeDao dimCardContentTypeDao = new DimCardContentTypeDao(dimJdbcUrl);
                        return (V) dimCardContentTypeDao.findAllDimCardContentType(tableName);
                    case DIM_TRANSACTION_TYPE:
                        DimTableDao dimTransactionTypeDao = new DimTableDao(dimJdbcUrl);
                        return (V) dimTransactionTypeDao.findAllDimTable(tableName);
                    case DIM_PAGE_TYPE:
                        DimPageTypeDao dimPageTypeDao = new DimPageTypeDao(dimJdbcUrl);
                        return (V) dimPageTypeDao.findAllDimPageType(tableName);
                    case DIM_CARD_TYPE:
                        DimTableDao dimCardTypeDao = new DimTableDao(dimJdbcUrl);
                        return (V) dimCardTypeDao.findAllDimTable(tableName);
                    default:
                        return null;

                }
            } else {
                switch(DimTableList.getDimTableByName(tableName)) {
                    case DIM_CITY:
                        DimCityDao dimCityDao = new DimCityDao(dimJdbcUrl);
                        DimCity dimCity = dimCityDao.findDimCityByCode(tableName, code);
                        if (dimCity == null) {
                            dimCity = dimCityDao.findDimCityByPk(tableName, code);
                        }
                        return (V) dimCity;
                    case DIM_CARD_CONTENT_TYPE:
                        DimCardContentTypeDao dimCardContentTypeDao = new DimCardContentTypeDao(dimJdbcUrl);
                        return (V) dimCardContentTypeDao.findDimCardContentTypeByCode(tableName, code);
                    case DIM_TRANSACTION_TYPE:
                        DimTableDao dimTransactionTypeDao = new DimTableDao(dimJdbcUrl);
                        return (V) dimTransactionTypeDao.findDimTableByCode(tableName, code);
                    case DIM_PAGE_TYPE:
                        DimPageTypeDao dimPageTypeDao = new DimPageTypeDao(dimJdbcUrl);
                        return (V) dimPageTypeDao.findDimPageTypeByCode(tableName, code);
                    case DIM_CARD_TYPE:
                        DimTableDao dimCardTypeDao = new DimTableDao(dimJdbcUrl);
                        return (V) dimCardTypeDao.findDimTableByCode(tableName, code);
                    default:
                        return null;

                }
            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return null;
//        }
    }
}
