package com.gmei.cache;

import com.gmei.bean.ml.MlPreciseExposureBean;
import com.gmei.jdbc.MysqlJdbcSink;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName: MlPreciseExposureDao
 * Function:
 * Reason: ml_c_et_pe_preciseexposure_dimen_d_rt数据下发操作类
 * Date: 2019/12/19 上午11:35
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MlPreciseExposureDao {
    private MysqlJdbcSink mysqlJdbcSink;
    private String sql;
    private String sinkJdbcUrl;
    private String sinkTableName;

    public MlPreciseExposureDao(String sinkJdbcUrl, String sinkTableName) {
        this.sinkJdbcUrl = sinkJdbcUrl;
        this.sinkTableName = sinkTableName;
        this.mysqlJdbcSink = MysqlJdbcSink.getInstance(sinkJdbcUrl);
    }

    /**
    * Function: insertMlPreciseExposure
    * Reason: 向表中插入数据
    * Date: 2019/12/25 下午5:38
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public void insertMlPreciseExposure(MlPreciseExposureBean mlPreciseExposureBean) throws Exception {
        sql = "insert into " + sinkTableName + "\n" +
                "  (action,\n" +
                "   app_code,\n" +
                "   page_code,\n" +
                "   page_name,\n" +
                "   tab_name,\n" +
                "   business_id,\n" +
                "   referrer_code,\n" +
                "   referrer_name,\n" +
                "   referrer_id,\n" +
                "   card_id,\n" +
                "   card_name,\n" +
                "   card_content_type,\n" +
                "   card_content_type_name,\n" +
                "   card_type,\n" +
                "   card_type_name,\n" +
                "   is_cpc,\n" +
                "   cpc_referer,\n" +
                "   transaction_type,\n" +
                "   transaction_type_name,\n" +
                "   filter,\n" +
                "   query,\n" +
                "   app_version,\n" +
                "   user_id,\n" +
                "   device_id,\n" +
                "   device_os_type,\n" +
                "   current_city_id,\n" +
                "   current_city_name,\n" +
                "   current_province_id,\n" +
                "   current_province_name,\n" +
                "   current_country_id,\n" +
                "   current_country_name,\n" +
                "   current_region_id,\n" +
                "   current_region_name,\n" +
                "   create_time_day,\n" +
                "   gm_nginx_time_day,\n" +
                "   preciseexposure_num)\n" +
                "values\n" +
                "  (?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?,\n" +
                "   ?)";

        List<Object> params = new ArrayList<Object>();
        params.add(mlPreciseExposureBean.getAction());
//        params.add(mlPreciseExposureBean.getAction_name());
        params.add(mlPreciseExposureBean.getApp_code());
        params.add(mlPreciseExposureBean.getPage_code());
        params.add(mlPreciseExposureBean.getPage_name());
        params.add(mlPreciseExposureBean.getTab_name());
        params.add(mlPreciseExposureBean.getBusiness_id());
        params.add(mlPreciseExposureBean.getReferrer_code());
        params.add(mlPreciseExposureBean.getReferrer_name());
        params.add(mlPreciseExposureBean.getReferrer_id());
        params.add(mlPreciseExposureBean.getCard_id());
        params.add(mlPreciseExposureBean.getCard_name());
        params.add(mlPreciseExposureBean.getCard_content_type());
        params.add(mlPreciseExposureBean.getCard_content_type_name());
        params.add(mlPreciseExposureBean.getCard_type());
        params.add(mlPreciseExposureBean.getCard_type_name());
        params.add(mlPreciseExposureBean.getIs_cpc());
        params.add(mlPreciseExposureBean.getCpc_referer());
        params.add(mlPreciseExposureBean.getTransaction_type());
        params.add(mlPreciseExposureBean.getTransaction_type_name());
        params.add(mlPreciseExposureBean.getFilter());
        params.add(mlPreciseExposureBean.getQuery());
        params.add(mlPreciseExposureBean.getApp_version());
        params.add(mlPreciseExposureBean.getUser_id());
        params.add(mlPreciseExposureBean.getDevice_id());
        params.add(mlPreciseExposureBean.getDevice_os_type());
        params.add(mlPreciseExposureBean.getCurrent_city_id());
        params.add(mlPreciseExposureBean.getCurrent_city_name());
        params.add(mlPreciseExposureBean.getCurrent_province_id());
        params.add(mlPreciseExposureBean.getCurrent_province_name());
        params.add(mlPreciseExposureBean.getCurrent_country_id());
        params.add(mlPreciseExposureBean.getCurrent_country_name());
        params.add(mlPreciseExposureBean.getCurrent_region_id());
        params.add(mlPreciseExposureBean.getCurrent_region_name());
        params.add(mlPreciseExposureBean.getCreate_time_day());
        params.add(mlPreciseExposureBean.getGm_nginx_time_day());
        params.add(mlPreciseExposureBean.getPreciseexposure_num());
//        System.out.println(params.toString());
        mysqlJdbcSink.update(sql, params);
    }
}
