package com.gmei.function;

import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.bean.bl.BlPreciseExposureParamsExposureCardsBean;
import com.gmei.bean.ml.MlPreciseExposureBean;
import com.gmei.utils.BeanReflectUtil;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * ClassName: MlpreciseExposureFlatMapFunction
 * Function:
 * Reason: ML层数据清洗转换器（一对多）
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MlpreciseExposureFlatMapFunction implements FlatMapFunction<BlPreciseExposureBean, MlPreciseExposureBean> {
    @Override
    public void flatMap(BlPreciseExposureBean blPreciseExposureBean, Collector<MlPreciseExposureBean> collector) throws Exception {
        ArrayList<MlPreciseExposureBean> mlPreciseExposureBeanList = flatmapBlPreciseExposure(blPreciseExposureBean);
//        System.out.println("MlpreciseExposureFlatMapFunction" + blPreciseExposureBean);
        for (MlPreciseExposureBean mlPreciseExposureBean : mlPreciseExposureBeanList) {
            collector.collect(mlPreciseExposureBean);
        }
    }

    /**
    * Function: flatmapBlPreciseExposure
    * Reason: 数据爆炸（LATERAL VIEW EXPLODE）
    * Date: 2019/12/25 下午5:14
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList<MlPreciseExposureBean> flatmapBlPreciseExposure(BlPreciseExposureBean blPreciseExposureBean) throws Exception {
        ArrayList<BlPreciseExposureParamsExposureCardsBean> exposure_cards = blPreciseExposureBean.getExposure_cards();
        String app_version = blPreciseExposureBean.getApp_version();
        String device_os_type = blPreciseExposureBean.getDevice_os_type();
        ArrayList<MlPreciseExposureBean> mlPreciseExposureBeanList = new ArrayList<>();
        for(BlPreciseExposureParamsExposureCardsBean exposureCardsBean: exposure_cards) {
            String card_id = exposureCardsBean.getCard_id();
            String card_content_type = exposureCardsBean.getCard_content_type();
            String card_type = exposureCardsBean.getCard_type();
            String card_name = exposureCardsBean.getCard_name();
            String target_name = exposureCardsBean.getTarget_name();
            String is_cpc = exposureCardsBean.getIs_cpc();
            String cpc_referer = exposureCardsBean.getCpc_referer();
            String absolute_position = exposureCardsBean.getAbsolute_position();
            String relative_position = exposureCardsBean.getRelative_position();
            String transaction_type = exposureCardsBean.getTransaction_type();

            //1.3 绝对位置和相对位置位置错误
            //问题描述：在'7.7.35','7.7.36' android的绝对位置和相对位置写反
            if("android".equals(device_os_type) && ("7.7.35".equals(app_version) || "7.7.36".equals(app_version))) {
                String change = absolute_position;
                absolute_position = relative_position;
                relative_position = change;
            }

            //1.10 banner、豆腐块、icon、搜索词和功能区入口的card_type参数问题
            //问题描述：当卡片类型为豆腐块、icon、banner、搜索词和功能区入口的时候的时候正确的card_type的参数值被赋给了card_content_type（banner、icon、gadget、search_query、function_entrance）
            List<String> card_content_type_list = Arrays.asList("banner","icon","gadget","search_query","function_entrance");
            if (card_content_type_list.contains(card_content_type)) {
                card_type = card_content_type;
                card_content_type = null;
            }
            if ("search_query".equals(card_type)) {
                card_type = "search_word";
            }

            //1.12 card_content_type的qa值应该被换成q_a
            if ("qa".equals(card_content_type)) {
                card_content_type = card_content_type.replace("qa","q_a");
            }

            //1.13 target_name与card_name的参数的统一
            //问题描述：将target_name参数的值赋给card_name
            //1.14 百科卡片曝光新增参数wiki_type
            //问题：从7.19.0版本开始，百科卡片曝光,新增了wiki_type参数

            //card_type为card的标准码值为common_card,数据中为card
            if("card".equals(card_type)) {
                card_type = "common_card";
            }
            //card_type为banner的标准码值为common_banner,数据中为banner
            if("banner".equals(card_type)) {
                card_type = "common_banner";
            }

            MlPreciseExposureBean mlPreciseExposureBean = new MlPreciseExposureBean();
            mlPreciseExposureBean.setUser_id(blPreciseExposureBean.getUser_id());
            mlPreciseExposureBean.setAction(blPreciseExposureBean.getAction());

            mlPreciseExposureBean.setPage_code(blPreciseExposureBean.getPage_code());

            mlPreciseExposureBean.setTab_name(blPreciseExposureBean.getTab_name());
            mlPreciseExposureBean.setBusiness_id(blPreciseExposureBean.getBusiness_id());
            mlPreciseExposureBean.setReferrer_code(blPreciseExposureBean.getReferrer_code());

            mlPreciseExposureBean.setReferrer_id(blPreciseExposureBean.getReferrer_id());

            mlPreciseExposureBean.setCard_id(card_id);
            mlPreciseExposureBean.setCard_content_type(card_content_type);

            //1.13 target_name与card_name的参数的统一
            //问题描述：将target_name参数的值赋给card_name
            mlPreciseExposureBean.setCard_name(card_name == null ? target_name : card_name);

            mlPreciseExposureBean.setCard_type(card_type);
            mlPreciseExposureBean.setIs_cpc(is_cpc);
            mlPreciseExposureBean.setCpc_referer(cpc_referer);
//            mlPreciseExposureBean.setAbsolute_position(absolute_position);
//            mlPreciseExposureBean.setRelative_position(relative_position);
            mlPreciseExposureBean.setTransaction_type(transaction_type);

            mlPreciseExposureBean.setFilter(blPreciseExposureBean.getFilter());
            mlPreciseExposureBean.setQuery(blPreciseExposureBean.getQuery());
//            mlPreciseExposureBean.setChannel_id(blPreciseExposureBean.getApp_channel());
            mlPreciseExposureBean.setApp_version(blPreciseExposureBean.getApp_version());
            mlPreciseExposureBean.setCurrent_city_id(blPreciseExposureBean.getApp_current_city_id());

            mlPreciseExposureBean.setApp_code(blPreciseExposureBean.getApp_code());
            mlPreciseExposureBean.setDevice_os_type(blPreciseExposureBean.getDevice_os_type());
            mlPreciseExposureBean.setDevice_id(blPreciseExposureBean.getDevice_id());
            mlPreciseExposureBean.setCreate_time_day(blPreciseExposureBean.getCreate_time_day());
            mlPreciseExposureBean.setGm_nginx_time_day(blPreciseExposureBean.getGm_nginx_time_day());
            mlPreciseExposureBean.setPreciseexposure_num(1);

            //1.11 transaction_type的空值需要被修正
            //问题描述：transaction_type='' 需要替换为NULL
            mlPreciseExposureBeanList.add(BeanReflectUtil.setNullValue(mlPreciseExposureBean));
        }
        return mlPreciseExposureBeanList;
    }
}
