package com.gmei.sink;

import com.alibaba.fastjson.JSON;
import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.cache.BlPreciseExposureDao;
import com.gmei.cache.SimpleCacheService;
import com.gmei.jdbc.MysqlJdbcSink;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

/**
 * ClassName: BlPreciseExposureMysqlSink
 * Function:
 * Reason: 数据下发mysql
 * Date: 2019/12/16 下午6:45
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureKafkaSink extends RichSinkFunction<BlPreciseExposureBean> {

    private String outBrokers;
    private String outTopic;
    private Properties props;
    private KafkaProducer<String,String> kafkaProducer;


    public BlPreciseExposureKafkaSink(String outBrokers, String outTopic) {
        this.outBrokers = outBrokers;
        this.outTopic = outTopic;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        init();
    }

    @Override
    public void invoke(BlPreciseExposureBean value, Context context) throws Exception {
        kafkaProducer.send(new ProducerRecord<String,String>(outTopic, JSON.toJSONString(value)));
    }

    @Override
    public void close() throws Exception {
        super.close();
        kafkaProducer.close();
    }

    private void init() throws Exception {
        props = new Properties();
        props.setProperty(ProducerConfig.BOOTSTRAP_SERVERS_CONFIG,outBrokers);
        props.setProperty(ProducerConfig.COMPRESSION_TYPE_CONFIG,"lz4");
        props.setProperty(ProducerConfig.KEY_SERIALIZER_CLASS_CONFIG,"org.apache.kafka.common.serialization.StringSerializer");
        props.setProperty(ProducerConfig.VALUE_SERIALIZER_CLASS_CONFIG,"org.apache.kafka.common.serialization.StringSerializer");
        kafkaProducer = new KafkaProducer(props);
    }
}