package com.gmei.sink;

import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.cache.BlPreciseExposureDao;
import com.gmei.jdbc.MysqlJdbcSink;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;

/**
 * ClassName: BlPreciseExposureMysqlSink
 * Function:
 * Reason: 数据下发mysql
 * Date: 2019/12/16 下午6:45
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureMysqlSink extends RichSinkFunction<BlPreciseExposureBean> {

    private MysqlJdbcSink mysqlJdbcSink;
    private Connection conn;
    private BlPreciseExposureDao blPreciseExposureDao;
    private int maxRetry = 1;
    private long retryTime = 3000;
    private String sinkJdbcUrl;
    private String sinkTableName;

    public BlPreciseExposureMysqlSink(String sinkJdbcUrl, String sinkTableName) {
        this.sinkJdbcUrl = sinkJdbcUrl;
        this.sinkTableName = sinkTableName;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        mysqlJdbcSink = MysqlJdbcSink.getInstance(sinkJdbcUrl);
        blPreciseExposureDao = new BlPreciseExposureDao(sinkJdbcUrl, sinkTableName);
        conn = mysqlJdbcSink.getConnection();
    }

    @Override
    public void invoke(BlPreciseExposureBean value, Context context) throws Exception {

        try {
            conn.setAutoCommit(false);
            blPreciseExposureDao.insertBlPreciseExposure(value);
            conn.commit();
        } catch (Exception e) {
            conn.rollback();
            int numRetry = 1;
            Exception lastException = e;
            while (numRetry <= maxRetry) {
                try {
                    numRetry ++;
                    Thread.sleep(retryTime);
                    mysqlJdbcSink.close(conn, null, null);
                    conn = mysqlJdbcSink.getConnection();
                    conn.setAutoCommit(false);
                    blPreciseExposureDao.insertBlPreciseExposure(value);
                    conn.commit();
                } catch (Exception e1) {
                    conn.rollback();
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        mysqlJdbcSink.close(conn, null, null);
    }
}
