package com.gmei.source;

import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer011;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Properties;


/**
 * ClassName: BlMaiDianKafkaSource
 * Function:
 * Reason: 获取kafka资源
 * Date: 2019/12/5 下午3:54
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlMaiDianKafkaSource {

    private String brokers;
    private String topic;
    private String groupId;
    private String startTime;


    public BlMaiDianKafkaSource() {
    }

    public BlMaiDianKafkaSource(String brokers, String topic, String groupId, String startTime) {
        this.brokers = brokers;
        this.topic = topic;
        this.groupId = groupId;
        this.startTime = startTime;
    }

    /**
    * Function: addSource
    * Reason: 获取kafka资源
    * Date: 2019/12/25 下午4:49
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public FlinkKafkaConsumer011<String> addSource() throws Exception{
        Properties props = new Properties();
        props.put("bootstrap.servers", brokers);
        props.put("group.id", groupId);
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
//        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        FlinkKafkaConsumer011<String> flinkKafkaConsumer = new FlinkKafkaConsumer011<String>(topic, new SimpleStringSchema(Charset.forName("UTF-8")), props);
//
        if(startTime != null){
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            flinkKafkaConsumer.setStartFromTimestamp(simpleDateFormat.parse(startTime).getTime());
        } else {
            flinkKafkaConsumer.setStartFromGroupOffsets();//默认消费策略
        }
//        flinkKafkaConsumer.setStartFromEarliest();
        return flinkKafkaConsumer;
    }

    public DataStreamSource<String> addSource(StreamExecutionEnvironment streamExecutionEnvironment) {
        StreamExecutionEnvironment env = streamExecutionEnvironment;

        String topicName = "test";
        String groupId = "group1";
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9092");
        props.put("group.id", groupId);
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");

        FlinkKafkaConsumer011<String> flinkKafkaConsumer = new FlinkKafkaConsumer011<String>(topicName, new SimpleStringSchema(), props);
        flinkKafkaConsumer.setStartFromGroupOffsets();//默认消费策略
//        flinkKafkaConsumer.setStartFromEarliest();
        DataStreamSource<String> dataStreamSource = env.addSource(flinkKafkaConsumer);
        return dataStreamSource;
    }
}
