INSERT OVERWRITE TABLE BL_ET_MG_PRECISEEXPOSURE_INC_D PARTITION (PARTITION_DAY = '${partition_day}')
  SELECT T1.JSON AS JSON, --原始日志
         T1.GM_NGINX_KEY AS GM_NGINX_KEY,
         T1.VERSION AS VERSION,
         T1.PARAMS AS PARAMS, --埋点参数字段
         T1.APP_SESSION_ID AS APP_SESSION_ID, --客户端会话ID
         T1.GM_NGINX_TIMESTAMP AS GM_NGINX_TIMESTAMP, --服务端接收时间戳
         T1.CREATE_TIMESTAMP AS CREATE_TIMESTAMP, --时间戳
         T1.APP AS APP, --埋点APP字段
         T1.DEVICE AS DEVICE, --埋点DEVICE字段
         T1.USER_ID AS USER_ID, --用户ID
         T1.ACTION AS TYPE, --事件名称
         T1.PARAMS_DOWN_LOADING_TIMES AS PARAMS_DOWN_LOADING_TIMES, --下拉加载次数
         T1.PARAMS_DOWN_SLIDE_TIMES AS PARAMS_DOWN_SLIDE_TIMES, --下拉滑动次数
         T1.PARAMS_UP_LOADING_TIMES AS PARAMS_UP_LOADING_TIMES, --上拉加载次数
         T1.PARAMS_UP_SLIDE_TIMES AS PARAMS_UP_SLIDE_TIMES, --上拉滑动次数
         T1.PARAMS_PAGE_NAME AS PARAMS_PAGE_NAME, --页面编码
         T1.PARAMS_TAB_NAME AS PARAMS_TAB_NAME, --页面TAB名称
         T1.PARAMS_BUSINESS_ID AS PARAMS_BUSINESS_ID, --页面ID
         T1.PARAMS_REFERRER AS PARAMS_REFERRER, --来源页面编码
         T1.PARAMS_REFERRER_ID AS PARAMS_REFERRER_ID, --来源页面ID
         T1.PARAMS_EXPOSURE_CARDS AS PARAMS_EXPOSURE_CARDS, --精准曝光数据块
         T1.PARAMS_IS_EXPOSURE AS PARAMS_IS_EXPOSURE, --是否是精准曝光
         T1.PARAMS_FILTER AS PARAMS_FILTER, --筛选器内容
         T1.PARAMS_QUERY AS PARAMS_QUERY, --搜索词
         T1.APP_GREY_TYPE AS APP_GREY_TYPE, --灰度组类型
         T1.APP_CHANNEL AS APP_CHANNEL, --渠道ID
         T1.APP_VERSION AS APP_VERSION, --客户端版本
         T1.APP_SERIAL_ID AS APP_SERIAL_ID, --埋点序列ID
         NVL(T2.CITY_ID,T1.APP_CURRENT_CITY_ID) AS APP_CURRENT_CITY_ID, --当前城市ID
         T1.APP_NAME AS APP_NAME, --APP名称
         T1.APP_USER_TYPE AS APP_USER_TYPE, --APP用户类型
         T1.DEVICE_IS_WIFI AS DEVICE_IS_WIFI, --是否WIFI
         T1.DEVICE_TYPE AS DEVICE_TYPE, --设备类型
         T1.DEVICE_MODEL AS DEVICE_MODEL, --设备型号
         T1.DEVICE_SYS_VERSION AS DEVICE_SYS_VERSION, --设备系统版本
         T1.DEVICE_NET_TYPE AS DEVICE_NET_TYPE, --设备网络类型
         T1.DEVICE_ID AS DEVICE_ID, --设备ID
         T1.DEVICE_ANDROID_ID AS DEVICE_ANDROID_ID, --设备安卓ID
         T1.DEVICE_LNG AS DEVICE_LNG, --设备经度
         T1.DEVICE_LAT AS DEVICE_LAT, --设备纬度
         T1.DEVICE_IP AS DEVICE_IP, --设备IP
         T1.DEVICE_MANUFACTURER AS DEVICE_MANUFACTURER, --设备制造商
         T1.DEVICE_IDFV AS DEVICE_IDFV, --设备IDFV
         T1.DEVICE_IDFA AS DEVICE_IDFA, --设备IDFA
         T1.GM_NGINX_TIME_DATE AS GM_NGINX_TIME_DATE, --服务端接收时间
         T1.GM_NGINX_TIME_DAY AS GM_NGINX_TIME_DAY, --服务端接收日期
         T1.TIME_DATE AS CREATE_TIME_DATE, --时间戳格式化后的时间
         T1.TIME_DAY AS CREATE_TIME_DAY --时间戳格式化后的日期
    FROM (SELECT REGEXP_REPLACE(REGEXP_REPLACE(T.JSON,'\\s+',''), '\\\\\\\\n', '') JSON, --原始JSON
                 --第一级别JSON
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.gm_nginx_key')) = '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.gm_nginx_key'))) GM_NGINX_KEY,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.version')) = '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.version'))) VERSION,
                 CASE
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.params')) = '' OR GET_JSON_OBJECT(LV.RAW, '$.params') IS NULL THEN
                    JSON_MAP('{}', 'string,string')
                   WHEN IS_JSON(GET_JSON_OBJECT(LV.RAW, '$.params')) = 'true' THEN
                    JSON_MAP(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params')), 'string,string')
                   ELSE JSON_MAP(REGEXP_REPLACE(REGEXP_REPLACE(REGEXP_REPLACE(TRIM(GET_JSON_OBJECT(LV.RAW,'$.params')),'("){2}','"'),':",',':"",'),':"}',':""}'),'string,string')
                 END PARAMS,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app_session_id')) = '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.app_session_id'))) APP_SESSION_ID,
                 CAST(CAST(TRIM(GET_JSON_OBJECT(LV.RAW, '$.gm_nginx_timestamp')) AS DOUBLE) AS BIGINT) GM_NGINX_TIMESTAMP,
                 CAST(CAST(TRIM(GET_JSON_OBJECT(LV.RAW, '$.create_at')) AS DOUBLE) AS BIGINT) CREATE_TIMESTAMP,
                 CASE
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.app')) = '' OR GET_JSON_OBJECT(LV.RAW, '$.app') IS NULL THEN
                    JSON_MAP('{}', 'string,string')
                   ELSE
                    JSON_MAP(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app')), 'string,string')
                 END AS APP,
                 CASE
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.device')) = '' OR GET_JSON_OBJECT(LV.RAW, '$.device') IS NULL THEN
                    JSON_MAP('{}', 'string,string')
                   ELSE
                    JSON_MAP(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device')), 'string,string')
                 END AS DEVICE,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.user_id'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.user_id'))) AS USER_ID,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.type'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.type'))) AS ACTION,
                 --第二级别JSON
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.down_loading_times'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.down_loading_times'))) AS PARAMS_DOWN_LOADING_TIMES,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.down_slide_times'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.down_slide_times'))) AS PARAMS_DOWN_SLIDE_TIMES,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.up_loading_times'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.up_loading_times'))) AS PARAMS_UP_LOADING_TIMES,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.up_slide_times'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.up_slide_times'))) AS PARAMS_UP_SLIDE_TIMES,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.page_name'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.page_name'))) AS PARAMS_PAGE_NAME,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.tab_name'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.tab_name'))) AS PARAMS_TAB_NAME,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.business_id'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.business_id'))) AS PARAMS_BUSINESS_ID,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.referrer'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.referrer'))) AS PARAMS_REFERRER,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.referrer_id'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.referrer_id'))) AS PARAMS_REFERRER_ID,
                 CASE
                   WHEN IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_type'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_type'))) = 'android' AND
                        IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.version'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.version'))) IN ('7.7.35', '7.7.36', '7.7.40') THEN
                     JSON_SPLIT(REGEXP_REPLACE(TO_JSON(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.exposure_cards'))), 'absolute_position', '\\\\"absolute_position'))
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.exposure_cards')) = '' OR GET_JSON_OBJECT(LV.RAW, '$.params.exposure_cards') IS NULL THEN
                     ARRAY()
                   ELSE
                     JSON_SPLIT(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.exposure_cards')))
                 END PARAMS_EXPOSURE_CARDS,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.is_exposure'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.is_exposure'))) PARAMS_IS_EXPOSURE,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.filter'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.filter'))) PARAMS_FILTER,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.query'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.query'))) PARAMS_QUERY,
                 CASE
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.grey_type')) IN ('', 'unknown') OR GET_JSON_OBJECT(LV.RAW, '$.app.grey_type') IS NULL THEN
                    JSON_MAP('{}', 'string,string')
                   ELSE
                    JSON_MAP(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.grey_type')), 'string,string')
                 END APP_GREY_TYPE,
                 CASE
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.channel'))= '' THEN
                    NULL
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.channel'))= 'AppStore' THEN
                    'App Store'
                   ELSE
                    TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.channel'))
                 END AS APP_CHANNEL,
                --  IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.channel'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.channel'))) APP_CHANNEL,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.version'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.version'))) APP_VERSION,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.serial_id'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.serial_id'))) APP_SERIAL_ID,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.current_city_id'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.current_city_id'))) APP_CURRENT_CITY_ID,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.name'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.name'))) APP_NAME,
                 CASE
                     WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.user_type')) = ''
                         OR GET_JSON_OBJECT(LV.RAW, '$.app.user_type') IS NULL THEN JSON_MAP('{}', 'string,string')
                     ELSE JSON_MAP(TRIM(GET_JSON_OBJECT(LV.RAW, '$.app.user_type')), 'string,string')
                     END AS APP_USER_TYPE,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.is_WiFi'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.is_WiFi'))) DEVICE_IS_WIFI,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_type'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_type'))) DEVICE_TYPE,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.model'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.model'))) DEVICE_MODEL,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.sys_version'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.sys_version'))) DEVICE_SYS_VERSION,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.net_type'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.net_type'))) DEVICE_NET_TYPE,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.android_device_id'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.android_device_id'))) DEVICE_ANDROID_ID,
                 CASE
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_id'))= '' AND TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.idfv'))<> '' THEN
                    TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.idfv'))
                   WHEN TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_id'))= '' AND TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.idfv'))= '' THEN
                    NULL
                   ELSE
                    TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_id'))
                 END AS DEVICE_ID,
                --  IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_id'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.device_id'))) DEVICE_ID,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.lng'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.lng'))) DEVICE_LNG,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.lat'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.lat'))) DEVICE_LAT,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.ip'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.ip'))) DEVICE_IP,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.manufacturer'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.manufacturer'))) DEVICE_MANUFACTURER,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.idfv'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.idfv'))) DEVICE_IDFV,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.idfa'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.device.idfa'))) DEVICE_IDFA,
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.gm_nginx_timestamp'))= '', NULL, FROM_UNIXTIME(CAST(CAST(TRIM(GET_JSON_OBJECT(LV.RAW, '$.gm_nginx_timestamp')) AS DOUBLE) AS BIGINT),'yyyy-MM-dd HH:mm:ss')) GM_NGINX_TIME_DATE, --服务端接收时间
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.gm_nginx_timestamp'))= '', NULL, FROM_UNIXTIME(CAST(CAST(TRIM(GET_JSON_OBJECT(LV.RAW, '$.gm_nginx_timestamp')) AS DOUBLE) AS BIGINT),'yyyyMMdd')) GM_NGINX_TIME_DAY, --服务端接收日期
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.create_at'))= '', NULL, FROM_UNIXTIME(CAST(CAST(TRIM(GET_JSON_OBJECT(LV.RAW, '$.create_at')) AS DOUBLE) AS BIGINT),'yyyy-MM-dd HH:mm:ss')) TIME_DATE, --时间戳格式化后的时间
                 IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.create_at'))= '', NULL, FROM_UNIXTIME(CAST(CAST(TRIM(GET_JSON_OBJECT(LV.RAW, '$.create_at')) AS DOUBLE) AS BIGINT),'yyyyMMdd')) TIME_DAY, --时间戳格式化后的日期
                 ROW_NUMBER() OVER(PARTITION BY T.JSON) AS RANK_NUM
            FROM TL.TL_LOG_PRECISE_EXPOSURE T
         LATERAL VIEW JSON_TUPLE(REGEXP_REPLACE(REGEXP_REPLACE(T.JSON, '\\\\\\\\n', ''), '\\s+', ''), '@raw') LV AS RAW
           WHERE T.PARTITION_DAY = '${partition_day}'
            AND (CASE
                    WHEN IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.page_name'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.page_name')))='home' AND
                         IF(TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.is_popup'))= '', NULL, TRIM(GET_JSON_OBJECT(LV.RAW, '$.params.is_popup'))) IN (1, '1') THEN
                     0
                    ELSE
                     1
                 END) = 1) T1
    LEFT JOIN (SELECT T.ID AS CITY_ID,
                      T.TAG_ID AS TAG_ID
                 FROM TL.TL_ZX_API_CITY T
                WHERE T.PARTITION_DAY = '${partition_day}'
                  AND T.IS_ONLINE = 'true') T2
      ON T1.APP_CURRENT_CITY_ID = T2.TAG_ID
   WHERE RANK_NUM=1;