CREATE TABLE `dim_city` (
  `code` varchar(100) COMMENT '城市编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '城市TAGID' DEFAULT NULL,
  `name` varchar(100) COMMENT '城市名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '城市说明' DEFAULT NULL,
  `parent_province_code` varchar(100) COMMENT '省份编码' DEFAULT NULL,
  `parent_province_pk` varchar(100) COMMENT '省份TAGID' DEFAULT NULL,
  `parent_province_name` varchar(100) COMMENT '省份名称' DEFAULT NULL,
  `parent_province_memo` varchar(100) COMMENT '省份说明' DEFAULT NULL,
  `parent_country_code` varchar(100) COMMENT '国家编码' DEFAULT NULL,
  `parent_country_pk` varchar(100) COMMENT '国家TAGID' DEFAULT NULL,
  `parent_country_name` varchar(100) COMMENT '国家名称' DEFAULT NULL,
  `parent_country_memo` varchar(100) COMMENT '国家说明' DEFAULT NULL,
  `parent_region_code` varchar(100) COMMENT '区域编码' DEFAULT NULL,
  `parent_region_pk` varchar(100) COMMENT '区域ID' DEFAULT NULL,
  `parent_region_name` varchar(100) COMMENT '区域名称' DEFAULT NULL,
  `parent_region_memo` varchar(100) COMMENT '区域说明' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '城市码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;


CREATE TABLE `dim_page_type` (
  `code` varchar(100) COMMENT '页面编码' NOT NULL,
  `pk` varchar(100) COMMENT '页面主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '页面名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '页面说明' DEFAULT NULL,
  `parent_app_code` varchar(100) COMMENT '上级APP编码',
  `parent_app_pk` varchar(100) COMMENT '上级APP主键' DEFAULT NULL,
  `parent_app_name` varchar(100) COMMENT '上级APP名称' DEFAULT NULL,
  `parent_app_memo` varchar(100) COMMENT '上级APP说明' DEFAULT NULL,
  `type_s_code` varchar(100) COMMENT '页面分类小类编码' DEFAULT NULL,
  `type_s_name` varchar(100) COMMENT '页面分类小类名称' DEFAULT NULL,
  `type_m_code` varchar(100) COMMENT '页面分类中类编码' DEFAULT NULL,
  `type_m_name` varchar(100) COMMENT '页面分类中类名称' DEFAULT NULL,
  `type_l_code` varchar(100) COMMENT '页面分类大类编码' DEFAULT NULL,
  `type_l_name` varchar(100) COMMENT '页面分类大类名称' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL,
  PRIMARY KEY (`code`,`parent_app_code`)
) COMMENT '页面分类码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `dim_card_content_type` (
  `code` varchar(100) COMMENT '编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '说明' DEFAULT NULL,
  `new_code` varchar(100) COMMENT '转换后编码' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '卡片内容类型码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `dim_card_type` (
  `code` varchar(100) COMMENT '编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '说明' DEFAULT NULL,
  `new_code` varchar(100) COMMENT '转换后编码' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '卡片类型码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `dim_transaction_type` (
  `code` varchar(100) COMMENT '编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '说明' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '业务类型码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;
CREATE TABLE `bl_et_mg_preciseexposure_inc_d_rt` (
`json` longtext comment '原始JSON',
`gm_nginx_timestamp` varchar(200) comment '接受日志时间戳' default null,
`create_timestamp` varchar(200) comment '创建日志时间戳' default null,
`user_id` varchar(200) comment '用户ID' default null,
`action` varchar(200) comment '事件接口' default null,
`down_loading_times` int comment '下拉加载次数' default null,
`down_slide_times` int comment '下拉滑动次数' default null,
`up_loading_times` int comment '上拉加载次数' default null,
`up_slide_times` int comment '上拉滑动次数' default null,
`page_code` varchar(200) comment '页面编码' default null,
`tab_name` varchar(200) comment 'TAB名称' default null,
`business_id` varchar(200) comment '业务ID' default null,
`referrer_code` varchar(200) comment '来源页编码' default null,
`referrer_id` varchar(200) comment '来源页业务ID' default null,
`exposure_cards` varchar(10000) comment '卡片列表' default null,
`is_exposure` varchar(200) comment '是否精准曝光' default null,
`is_popup` varchar(200) comment '是否弹窗' default null,
`filter` varchar(200) comment '筛选器' default null,
`query` varchar(200) comment '搜索词' default null,
`app_grey_type` varchar(200) comment '灰度列表' default null,
`app_channel` varchar(200) comment 'APP渠道' default null,
`app_version` varchar(200) comment 'APP版本' default null,
`app_current_city_id` varchar(200) comment '当前城市ID' default null,
`app_code` varchar(200) comment 'APP编码' default null,
`device_os_type` varchar(200) comment '设备系统类型' default null,
`device_model` varchar(200) comment '设备型号' default null,
`device_id` varchar(200) comment '设备ID' default null,
`device_android_id` varchar(200) comment '设备安卓ID' default null,
`device_idfv` varchar(200) comment '设备IDFV' default null,
`gm_nginx_time_date` varchar(200) comment '日志接收时间' default null,
`gm_nginx_time_day` varchar(200) comment '日志接收日期' default null,
`create_time_date` varchar(200) comment '日志创建时间' default null,
`create_time_day` varchar(200) comment '日志创建日期' default null
) COMMENT 'BL层精准曝光实时表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;
CREATE TABLE `ml_c_et_pe_preciseexposure_dimen_d_rt` (
`user_id` varchar(200) comment '用户ID' default null,
`action` varchar(200) comment '事件接口' default null,
`page_code` varchar(200) comment '页面编码' default null,
`page_name` varchar(200) comment '页面名称' default null,
`tab_name` varchar(200) comment 'TAB名称' default null,
`business_id` varchar(200) comment '业务ID' default null,
`referrer_code` varchar(200) comment '来源页编码' default null,
`referrer_name` varchar(200) comment '来源页名称' default null,
`referrer_id` varchar(200) comment '来源页业务ID' default null,
`card_id` varchar(200) comment '卡片ID' default null,
`card_name` varchar(200) comment '卡片名称' default null,
`card_content_type` varchar(200) comment '卡片内容类型' default null,
`card_content_type_name` varchar(200) comment '卡片内容类型名称' default null,
`card_type` varchar(200) comment '卡片类型' default null,
`card_type_name` varchar(200) comment '卡片类型' default null,
`is_cpc` varchar(200) comment '是否CPC' default null,
`cpc_referer` varchar(200) comment 'CPC来源' default null,
`transaction_type` varchar(200) comment '业务类型' default null,
`transaction_type_name` varchar(200) comment '业务类型名称' default null,
`filter` varchar(200) comment '筛选器' default null,
`query` varchar(200) comment '搜索词' default null,
`app_version` varchar(200) comment 'APP版本' default null,
`current_city_id` varchar(200) comment '当前城市ID' default null,
`current_city_name` varchar(200) comment '当前城市名称' default null,
`current_province_id` varchar(200) comment '当前省份ID' default null,
`current_province_name` varchar(200) comment '当前省份名称' default null,
`current_country_id` varchar(200) comment '当前国家ID' default null,
`current_country_name` varchar(200) comment '当前国家名称' default null,
`current_region_id` varchar(200) comment '当前区域ID' default null,
`current_region_name` varchar(200) comment '当前区域名称' default null,
`app_code` varchar(200) comment 'APP编码' default null,
`device_os_type` varchar(200) comment '设备系统类型' default null,
`device_id` varchar(200) comment '设备ID' default null,
`create_time_day` varchar(200) comment '日志创建时间' default null,
`gm_nginx_time_day` varchar(200) comment '日志接收时间' default null,
`preciseexposure_num` int comment '精准曝光数量' default null
) COMMENT 'ML层精准曝光实时表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;


SELECT
	t1.CODE,
	t1.pk,
	t1.NAME,
	t1.memo,
	t1.parent_app_code,
	t1.parent_app_pk,
	t2.NAME parent_app_name,
	t2.memo parent_app_memo,
	t1.type_l_code,
	t1.type_l_name,
	t1.type_m_code,
	t1.type_m_name,
	t1.type_s_code,
	t1.type_s_name,
	t1.oid
FROM
	dim.dim_page_type t1
	LEFT JOIN dim.dim_app_name t2 ON t1.parent_app_code = t2.CODE;

SELECT
	t1.CODE,
	t1.pk,
	t1.NAME,
	t1.memo,
	t1.parent_code parent_province_code,
	t1.parent_pk parent_province_pk,
	t2.NAME parent_province_name,
	t2.memo parent_province_memo,
	t2.parent_country_code,
	t2.parent_country_pk,
	t3.NAME parent_country_name,
	t3.memo parent_country_memo,
	t2.parent_region_code,
	t2.parent_region_pk,
	t4.NAME parent_region_name,
	t4.memo parent_region_memo,
	t1.oid
FROM
	dim.dim_city t1
	LEFT JOIN dim.dim_province t2 ON t1.parent_code = t2.
	CODE LEFT JOIN dim.dim_country t3 ON t2.parent_country_code = t3.
	CODE LEFT JOIN dim.dim_region t4 ON t2.parent_region_code = t4.CODE;