package com.gmei.utils;

/**
 * ClassName: DimTableList
 * Function:
 * Reason: 维度码表列表枚举类
 * Date: 2019/12/12 上午11:34
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public enum DimTableList {

    DIM_CITY("dim_city", "城市码表"),
    DIM_CARD_TYPE("dim_card_type", "卡片类型码表"),
    DIM_CARD_CONTENT_TYPE("dim_card_content_type", "卡片内容类型码表"),
    DIM_PAGE_TYPE("dim_page_type", "页面分类编码"),
    DIM_TRANSACTION_TYPE("dim_transaction_type", "业务类型码表"),
    ;

    private String tableName;
    private String tableComment;

    DimTableList(String tableName, String tableComment) {
        this.tableName = tableName;
        this.tableComment = tableComment;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableComment() {
        return tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public static DimTableList getDimTableByName(String tableName) {
        for(DimTableList dimTable : values()) {
            if(dimTable.getTableName().equals(tableName)) {
                return dimTable;
            }
        }
        return null;
    }
}