package com.gmei;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.bean.MaidianEtl;
import com.gmei.map.GainValueMap;
import com.gmei.sink.KafkaSink;
import com.gmei.utils.GmKafkaConsumer;
import com.gmei.utils.StringUtils;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

import java.text.SimpleDateFormat;

/**
 * ClassName: com.gmei.FlinkServer
 * Function: TODO ADD FUNCTION.
 * Reason: 对客户端埋点进行Etl并累加open_times和durations(实时)
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class FlinkServer {
    public static void main(String[] args) throws Exception {
        String inBrokers;
        String inTopic;
        String groupId;
        String outJdbcUrl;
        String outTable;
        String outBrokers;
        String zxJdbcUrl;
        String outTopic;
        String startTime;
        String checkpointPath;
        Boolean isStartEarly;
        int parallelism;

        ParameterTool parameterTool = ParameterTool.fromArgs(args);
        outTable = parameterTool.get("outTable");
        inBrokers = parameterTool.get("inBrokers");
        inTopic = parameterTool.get("inTopic");
        groupId = parameterTool.get("groupId");
        zxJdbcUrl = parameterTool.get("zxJdbcUrl");
        outJdbcUrl = parameterTool.get("outJdbcUrl");
        outBrokers = parameterTool.get("outBrokers");
        outTopic = parameterTool.get("outTopic");
        startTime = parameterTool.get("startTime");
        checkpointPath = parameterTool.get("checkpointPath");
        isStartEarly = parameterTool.getBoolean("isStartEarly",false);
        parallelism = parameterTool.getInt("parallelism",1);


        System.out.println("=================params=================");
        System.out.println("outTable:" + outTable);
        System.out.println("inBrokers:" + inBrokers);
        System.out.println("inTopic:" + inTopic);
        System.out.println("groupId:" + groupId);
        System.out.println("zxJdbcUrl:" + zxJdbcUrl);
        System.out.println("outJdbcUrl:" + outJdbcUrl);
        System.out.println("outBrokers:" + outBrokers);
        System.out.println("outTopic:" + outTopic);
        System.out.println("startTime:" + startTime);
        System.out.println("checkpointPath:" + checkpointPath);
        System.out.println("isStartEarly:" + isStartEarly);
        System.out.println("parallelism:" + parallelism);
        System.out.println("========================================");


        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        env.enableCheckpointing(1000);
        env.setStateBackend(new FsStateBackend(checkpointPath));
        env.setRestartStrategy(RestartStrategies.fixedDelayRestart(1, 3000));
        CheckpointConfig config = env.getCheckpointConfig();
        config.enableExternalizedCheckpoints(CheckpointConfig.ExternalizedCheckpointCleanup.RETAIN_ON_CANCELLATION);

        GmKafkaConsumer gmKafkaConsumer = new GmKafkaConsumer(inTopic);
        gmKafkaConsumer.setSource(new SimpleStringSchema());
        gmKafkaConsumer.setProp("bootstrap.servers",inBrokers);
        gmKafkaConsumer.setProp("group.id",groupId);
        gmKafkaConsumer.setProp("batch.size","1000");

        if(isStartEarly){
            gmKafkaConsumer.getSource().setStartFromEarliest();
        }else if(startTime != null){
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            gmKafkaConsumer.getSource().setStartFromTimestamp(simpleDateFormat.parse(startTime).getTime());
        }

        DataStream<MaidianEtl> maidianEtl = env.addSource(gmKafkaConsumer.getSource())                .filter(new FilterFunction<String>() {
            @Override
            public boolean filter(String value) throws Exception {
                return JSON.isValid(value);
            }
        }).filter(new FilterFunction<String>() {
            @Override
            public boolean filter(String value) throws Exception {
                JSONObject jsonObject = JSON.parseObject(value);

                return !StringUtils.isObjectNull(jsonObject.get("create_at"));
            }
        }).filter(new FilterFunction<String>() {
            @Override
            public boolean filter(String value) throws Exception {
                JSONObject jsonObject = JSON.parseObject(value);
                String action = StringUtils.changeNullTolength0(jsonObject.get("type"));
                JSONObject paramsObject = jsonObject.getJSONObject("params");
                JSONObject appObject = jsonObject.getJSONObject("app");
                String name = "";
                if(!StringUtils.isObjectNull(appObject)){
                    name = StringUtils.changeNullTolength0(appObject.get("name"));
                }
                if("page_view".equals(action)){
                    String fake = "";
                    if(!StringUtils.isObjectNull(paramsObject)){
                        fake = StringUtils.changeNullTolength0("fake");
                    }

                    Double out = StringUtils.isNullToDouble(paramsObject.get("in"));
                    Double in = StringUtils.isNullToDouble(paramsObject.get("out"));

                    return ("0".equals(fake) && "gengmei_user".equals(name) && (out - in < 10800));
                }else {
                    return "gengmei_user".equals(name);
                }
            }
        }).map(new GainValueMap()).filter(new FilterFunction<MaidianEtl>() {
            @Override
            public boolean filter(MaidianEtl o) throws Exception {
                if("device_opened".equals(o.getAction()) || "on_app_session_over".equals(o.getAction())){
                    return true;
                }else {
                    return false;
                }
            }
        });
        DataStream<MaidianEtl> result = maidianEtl.filter(new FilterFunction<MaidianEtl>() {
            @Override
            public boolean filter(MaidianEtl value) throws Exception {
                if(value.getCl_id().length() == 0 && value.getCl_idfv().length() == 0){
                    return false;
                }else{
                    return true;
                }
            }
        }).filter(new FilterFunction<MaidianEtl>() {
            @Override
            public boolean filter(MaidianEtl value) throws Exception {
                String action = value.getAction();
                String serial_id = value.getSerial_id();

                return (("device_opened".equals(action) || "on_app_session_over".equals(action)) && serial_id.length() != 0);
            }
        }).keyBy(new KeySelector<MaidianEtl, String>() {
            @Override
            public String getKey(MaidianEtl value) throws Exception {
                return value.getApp_session_id() + "_" + value.getSerial_id();
            }
        });
        result.addSink(new KafkaSink(zxJdbcUrl,outJdbcUrl,outTable)).setParallelism(parallelism).uid("id-sink");
        env.execute("bl_hdfs_maidian_updates_flink");

    }
}
