package com.gmei.callable;

import com.gmei.bean.BackendDevice;
import com.gmei.bean.StaticTable;
import com.gmei.utils.JDBCUtils;

import java.sql.*;
import java.util.concurrent.Callable;

/**
 * ClassName: com.gmei.callable.BackendCallable
 * Function: TODO ADD FUNCTION.
 * Reason: 查询设备增量表数据
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class BackendCallable implements Callable<BackendDevice>{
    private String device_id;
    private String date;
    private Connection connection;
    private String jdbcUrl;

    public BackendCallable(String device_id, String date, Connection connection,String jdbcUrl) {
        this.device_id = device_id;
        this.date = date;
        this.connection = connection;
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public BackendDevice call() throws Exception {
        return findDevice(connection,device_id,date,jdbcUrl);
    }

    private BackendDevice findDevice(Connection connection, String device_id, String date,String jdbcUrl) throws SQLException {
        if(connection == null || connection.isClosed()){
            connection = DriverManager.getConnection(jdbcUrl);
        }
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(String.format("select device_id,open_times,duration from %s where date = '%s' and device_id = '%s'", StaticTable.ML_DEVICE_UPDATES, date, device_id));

        BackendDevice backendDevice = new BackendDevice();
        if(resultSet.next()){
            backendDevice.setDevice_id(device_id);
            backendDevice.setDate(date);
            backendDevice.setOpen_times(resultSet.getInt(2));
            backendDevice.setDurations(resultSet.getDouble(3 ));
        }

        JDBCUtils.close(null,statement,resultSet);
        return backendDevice;
    }
}
