package com.gmei.map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.bean.MaidianEtl;
import com.gmei.utils.StringUtils;
import org.apache.flink.api.common.functions.MapFunction;


/**
 * ClassName: com.gmei.map.GainValueMap
 * Function: TODO ADD FUNCTION.
 * Reason: 解释获取数据属性字段
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class GainValueMap implements MapFunction<String, MaidianEtl> {
    @Override
    public MaidianEtl map(String value) throws Exception {
        JSONObject jsonObject = JSON.parseObject(value);
        JSONObject appObject = jsonObject.getJSONObject("app");
        JSONObject deviceObject = jsonObject.getJSONObject("device");

        String create_at = jsonObject.get("create_at").toString();
        String gm_nginx_timestamp = jsonObject.get("gm_nginx_timestamp").toString();
        String action = StringUtils.changeNullTolength0(jsonObject.get("type"));
        String user_id = StringUtils.changeNullTolength0(jsonObject.get("user_id"));

        String city_id = "";
        String channel = "";
        String version = "";
        String serial_id = "";
        if (!StringUtils.isObjectNull(appObject)) {
            city_id = StringUtils.changeNullTolength0(appObject.get("current_city_id"));
            channel = StringUtils.changeNullTolength0(appObject.get("channel"));

            if ("AppStore".equals(channel)) {
                channel = "App Store";
            }

            version = StringUtils.changeNullTolength0(appObject.get("version"));
            serial_id = StringUtils.changeNullTolength0(appObject.get("serial_id"));
        }

        String app_session_id = StringUtils.changeNullTolength0(jsonObject.get("app_session_id"));

        String cl_id = "";
        String cl_type = "";
        String cl_idfv = "";
        if (!StringUtils.isObjectNull(deviceObject)) {
            cl_id = StringUtils.changeNullTolength0(deviceObject.get("device_id"));
            cl_type = StringUtils.changeNullTolength0(deviceObject.get("device_type"));
            cl_idfv = StringUtils.changeNullTolength0(deviceObject.get("idfv"));

            if (cl_id == "" && cl_idfv != "") {
                cl_id = cl_idfv;
            } else if (cl_id == "" && cl_idfv != "") {
                cl_id = null;
            }
        }

        String params = StringUtils.changeNullTolength0(jsonObject.get("params"));
        Double duration = 0.0;
        String new_params = "";
        if (!JSON.isValid(params)) {
            new_params = params.replace("(\"){2}", "\"").trim().replace(":\",", ":\"\",").replace(":\"}", ":\"\"}");
        } else {
            new_params = params;
        }
        JSONObject paramsObject = JSON.parseObject(new_params);
        if (paramsObject != null) {
            duration = StringUtils.isNullToDouble(paramsObject.get("duration"));
        }
        MaidianEtl maidianEtl = new MaidianEtl(create_at,
                gm_nginx_timestamp,
                action,
                user_id,
                city_id,
                channel,
                version,
                serial_id,
                app_session_id,
                cl_id,
                cl_idfv,
                cl_type,
                duration);
        return maidianEtl;
    }
}
