package com.gmei.sink;

import com.gmei.bean.BackendDevice;
import com.gmei.bean.MaidianEtl;
import com.gmei.bean.MaidianOpen;
import com.gmei.bean.StaticTable;
import com.gmei.cache.SimpleCacheService;
import com.gmei.callable.BackendCallable;
import com.gmei.callable.MaidianCallable;
import com.gmei.utils.JDBCUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ClassName: com.gmei.sink.KafkaSink
 * Function: TODO ADD FUNCTION.
 * Reason: 对客户端埋点进行Etl并累加open_times和durations-数据输出(实时)
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class KafkaSink extends RichSinkFunction<MaidianEtl> {
    private int maxRetry = 1;
    private long retryInteral = 3000;
    private String zxJdbcUrl;
    private String outJdbcUrl;
    private String outTable;
    private Connection zxConnection;
    private Connection outConnection;
    private SimpleCacheService<String,MaidianOpen> maidianCache;
    private SimpleCacheService<String,BackendDevice> backendCache;
    private SimpleDateFormat simpleDateFormat;

    public KafkaSink(String zxJdbcUrl, String outJdbcUrl, String outTable) {
        this.zxJdbcUrl = zxJdbcUrl;
        this.outJdbcUrl = outJdbcUrl;
        this.outTable = outTable;
    }

    @Override
    public void invoke(MaidianEtl value, Context context) throws Exception {

        try {
            sink(value);
        }catch (Exception e){
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    closeConn();
                    init();
                    e.printStackTrace();
                    System.out.println("retry++++++++++++++++++++++");
                    sink(value);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }

    /**
    * Function: TODO ADD FUNCTION.
    * Reason: sink输出数据处理主逻辑
    * Date:  2020-03-03 00:00:00
    *
    * @author sjxuwei
    * @since JDK 1.8
    */
    private void sink(MaidianEtl value) throws SQLException {
        String gm_nginx_timestamp = value.getGm_nginx_timestamp();
        long time = Double.valueOf(gm_nginx_timestamp).longValue() * 1000;
        String date = simpleDateFormat.format(new Date(time));
        MaidianOpen maidianOpen = maidianCache.getValue(value.getApp_session_id() + "_" + date + "_" + value.getSerial_id() + "_" + value.getCl_id(),
                new MaidianCallable(value.getApp_session_id(), outConnection, date, outTable,value.getSerial_id(),outJdbcUrl,value.getCl_id()));

        //借用数据库对数据去重并对设备的open_times和durations数据进行累加
        if(maidianOpen.getApp_session_id() == null) {
            String action = value.getAction();
            int open_times = 0;
            double durations = 0.0;
            if("device_opened".equals(action)){
                if("android".equals(value.getCl_type()) && "7.10.0".equals(value.getVersion())){
                    open_times = 0;
                }else{
                    open_times = 1;
                }
            }else if("android".equals(value.getCl_type()) && "7.10.0".equals(value.getVersion()) && "on_app_session_over".equals(value.getAction())){
                open_times = 1;
            }else{
                open_times = 0;
            }

            if(value.getDuration() < 20000 && value.getDuration() > 0){
                durations = value.getDuration();
            }else{
                durations = 0.0;
            }


            String device_id = value.getCl_id();
            BackendDevice backendDevice = backendCache.getValue(device_id + "_" + date, new BackendCallable(device_id, date, outConnection,outJdbcUrl));
            BackendDevice new_backendDevice = new BackendDevice();
            if(backendDevice.getDevice_id() == null){
                new_backendDevice.setDevice_id(device_id);
                new_backendDevice.setDate(date);
                new_backendDevice.setOpen_times(open_times);
                new_backendDevice.setDurations(durations);
            }else{
                new_backendDevice.setOpen_times(backendDevice.getOpen_times() + open_times);
                new_backendDevice.setDurations(backendDevice.getDurations() + durations);
            }
            backendCache.putValue(device_id + "_" + date,new_backendDevice);

            MaidianOpen new_data = new MaidianOpen();
            new_data.setApp_session_id(value.getApp_session_id());
            maidianCache.putValue(value.getApp_session_id() + "_" + date + "_" + value.getSerial_id() + "_" + device_id,new_data);
            insert(value,date);
            updateBackendDevice(device_id,date,open_times,durations);
        }
    }

    /**
    * Function: TODO ADD FUNCTION.
    * Reason: 更新设备增量表数据
    * Date: 2020-03-03 00:00:00
    *
    * @author sjxuwei
    * @since JDK 1.8
    */
    private void updateBackendDevice(String device_id, String date, int open_times,double duration) throws SQLException {
        Statement statement = outConnection.createStatement();
        statement.executeUpdate(String.format("insert into %s(device_id,open_times,date,duration) value('%s',%s,'%s',%s) ON DUPLICATE KEY UPDATE open_times = open_times + %s,duration = duration + %s", StaticTable.ML_DEVICE_UPDATES,device_id,open_times,date,duration,open_times,duration));
        JDBCUtils.close(null,statement,null);
    }

    private void closeConn() throws SQLException {
        JDBCUtils.close(zxConnection,null,null);
        JDBCUtils.close(outConnection,null,null);
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        init();
        super.open(parameters);
    }

    @Override
    public void close() throws Exception {
        closeConn();
        super.close();
    }

    /**
    * Function: TODO ADD FUNCTION.
    * Reason: 客户端埋点数据入库（主要借助数据库去重）
    * Date: 2020-03-03 00:00:00
    *
    * @author sjxuwei
    * @since JDK 1.8
    */
    private void insert(MaidianEtl value,String date) throws SQLException {
        Statement statement = outConnection.createStatement();
        statement.executeUpdate(String.format("insert into %s values('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s',%s,'%s')",
                outTable,
                value.getCreate_at(),
                value.getGm_nginx_timestamp(),
                value.getAction(),
                value.getUser_id(),
                value.getCity_id(),
                value.getChannel(),
                value.getVersion(),
                value.getSerial_id(),
                value.getApp_session_id(),
                value.getCl_id(),
                value.getCl_idfv(),
                value.getCl_type(),
                value.getDuration(),
                date));

        JDBCUtils.close(null,statement,null);
    }

    /**
    * Function: TODO ADD FUNCTION.
    * Reason: sink变量初始化.
    * Date: 2020-03-03 00:00:00
    *
    * @author sjxuwei
    * @since JDK 1.8
    */
    synchronized private void init() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        zxConnection = DriverManager.getConnection(zxJdbcUrl);
        outConnection = DriverManager.getConnection(outJdbcUrl);
        maidianCache = new SimpleCacheService<>(6000,2);
        backendCache = new SimpleCacheService<>(6000,2);
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    }
}
