package com.gmei.function;

import com.gmei.bean.bl.BlPreciseExposureBean;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.util.Collector;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * ClassName: BlPreciseExposureProcessFunction
 * Function:
 * Reason: BL层数据去重器
 * Date: 2020/1/8 下午5:06
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureProcessFunction extends ProcessAllWindowFunction<BlPreciseExposureBean, BlPreciseExposureBean, TimeWindow> {
    @Override
    public void process(Context context, Iterable<BlPreciseExposureBean> iterable, Collector<BlPreciseExposureBean> collector) throws Exception {
        Iterator<BlPreciseExposureBean> blPreciseExposureBeanIterator = iterable.iterator();
        Map<String, BlPreciseExposureBean> blPreciseExposureBeanMap = new HashMap<>();
        while (blPreciseExposureBeanIterator.hasNext()) {
            BlPreciseExposureBean blPreciseExposureBean = blPreciseExposureBeanIterator.next();
            blPreciseExposureBeanMap.put(blPreciseExposureBean.getJson(), blPreciseExposureBean);
        }

        Set<Map.Entry<String, BlPreciseExposureBean>> blPreciseExposureBeanSet = blPreciseExposureBeanMap.entrySet();
        for(Map.Entry<String, BlPreciseExposureBean> blPreciseExposureBeanEntry : blPreciseExposureBeanSet) {
            collector.collect(blPreciseExposureBeanEntry.getValue());
        }
    }
}
