package com.gmei.function;

import com.gmei.bean.ml.MlPreciseExposureBean;
import org.apache.flink.api.java.functions.KeySelector;

import java.util.ArrayList;

/**
 * ClassName: MlPreciseExposureKeySelector
 * Function:
 * Reason: ML层数据聚合分组器
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MlPreciseExposureKeySelector implements KeySelector<MlPreciseExposureBean, Object> {
    @Override
    public Object getKey(MlPreciseExposureBean mlPreciseExposureBean) throws Exception {
        ArrayList list = groupByFields(mlPreciseExposureBean);
        return list;
    }

    /**
    * Function: groupByFields
    * Reason: 分组字段（GROUP BY）
    * Date: 2019/12/25 下午5:17
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList groupByFields(MlPreciseExposureBean mlPreciseExposureBean) {
        ArrayList groupByFields = new ArrayList();
        groupByFields.add(mlPreciseExposureBean.getUser_id());
        groupByFields.add(mlPreciseExposureBean.getAction());
        groupByFields.add(mlPreciseExposureBean.getApp_code());
        groupByFields.add(mlPreciseExposureBean.getTab_name());
        groupByFields.add(mlPreciseExposureBean.getBusiness_id());
        groupByFields.add(mlPreciseExposureBean.getReferrer_code());
        groupByFields.add(mlPreciseExposureBean.getReferrer_id());
        groupByFields.add(mlPreciseExposureBean.getCard_id());
        groupByFields.add(mlPreciseExposureBean.getCard_name());
        groupByFields.add(mlPreciseExposureBean.getCard_content_type());
        groupByFields.add(mlPreciseExposureBean.getCard_type());
        groupByFields.add(mlPreciseExposureBean.getIs_cpc());
        groupByFields.add(mlPreciseExposureBean.getCpc_referer());
//        groupByFields.add(mlPreciseExposureBean.getAbsolute_position());
//        groupByFields.add(mlPreciseExposureBean.getRelative_position());
        groupByFields.add(mlPreciseExposureBean.getTransaction_type());
        groupByFields.add(mlPreciseExposureBean.getFilter());
        groupByFields.add(mlPreciseExposureBean.getQuery());
//        groupByFields.add(mlPreciseExposureBean.getChannel_id());
        groupByFields.add(mlPreciseExposureBean.getApp_version());
        groupByFields.add(mlPreciseExposureBean.getCurrent_city_id());
        groupByFields.add(mlPreciseExposureBean.getApp_code());
        groupByFields.add(mlPreciseExposureBean.getDevice_os_type());
        groupByFields.add(mlPreciseExposureBean.getDevice_id());
        groupByFields.add(mlPreciseExposureBean.getCreate_time_day());
        groupByFields.add(mlPreciseExposureBean.getGm_nginx_time_day());
        return groupByFields;
    }
}
