package com.gmei.schema;

import com.gmei.bean.bl.BlPreciseExposureBean;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.msgpack.MessagePack;
import org.msgpack.type.Value;
import org.msgpack.type.ValueFactory;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import static org.apache.flink.util.Preconditions.checkNotNull;

/**
 * ClassName: BlPreciseExposureSchema
 * Function:
 * Reason: 暂时未用到
 * Date: 2019/12/17 下午4:51
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureSchema implements DeserializationSchema<String>, SerializationSchema<String> {

    private static final long serialVersionUID = 1L;
    private transient Charset charset;


    public BlPreciseExposureSchema() {
        this(StandardCharsets.UTF_8);
    }

    public BlPreciseExposureSchema(Charset charset) {
        this.charset = checkNotNull(charset);
    }

    public Charset getCharset() {
        return charset;
    }

    private void writeObject (ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(charset.name());
    }

    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String charsetName = in.readUTF();
        this.charset = Charset.forName(charsetName);
    }

    @Override
    public String deserialize(byte[] bytes) throws IOException {

        String msg = new String(bytes, StandardCharsets.UTF_8);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(msg);
        BlPreciseExposureBean blPreciseExposureBean = mapper.readValue(msg, BlPreciseExposureBean.class);

        MessagePack msgpack = new MessagePack();
        Value MSGPACK_STRING_VALUE_CONTENT = ValueFactory.createRawValue("content".getBytes(StandardCharsets.US_ASCII));

        String contentString = "";
        try {
            contentString = msgpack.read(bytes).asMapValue().get(MSGPACK_STRING_VALUE_CONTENT).asRawValue().getString();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return contentString;
    }

    @Override
    public boolean isEndOfStream(String s) {
        return false;
    }

    @Override
    public byte[] serialize(String s) {
        return s.getBytes(charset);
    }

    @Override
    public TypeInformation<String> getProducedType() {
        return BasicTypeInfo.STRING_TYPE_INFO;
    }
}
