package com.gmei.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/**
 * ClassName: com.gmei.cache.SimpleCacheService
 * Function: TODO ADD FUNCTION.
 * Reason: 缓存池实现类
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class SimpleCacheService<K, V> extends CacheServiceAbstract<K, V> {

    private Cache<K, V> cache = null;
    private int maximumSize = 1000;
    private int expireAfterWrite = 1;

    public SimpleCacheService() {
        createCache();
    }

    public SimpleCacheService(int maximumSize, int expireAfterWrite) {

        this.maximumSize = maximumSize;
        this.expireAfterWrite = expireAfterWrite;
        createCache();
    }

    public void createCache() {
        cache = CacheBuilder
                .newBuilder()
                .maximumSize(maximumSize)
                .expireAfterWrite(expireAfterWrite, TimeUnit.HOURS)
                .build();
    }


    @Override
    public V getValue(final K key, final Callable<V> callable) {
        try {
            return cache.get(key, callable);
        } catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void putValue(K key, V value) {
        cache.put(key, value);
    }

    @Override
    public void invalidate(Object key) {
        cache.invalidate(key);
    }

    @Override
    public void clearCache(){
        this.cache.invalidateAll();
    }

    @Override
    public Long cacheSize() {
        return this.cache.size();
    }
}
