package com.gmei.callable;

import com.gmei.bean.StaticTable;
import com.gmei.utils.JDBCUtils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;

/**
 * ClassName: com.gmei.callable.CityCallable
 * Function: TODO ADD FUNCTION.
 * Reason: 查询城市id
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class CityCallable implements Callable<String>{
    private String city_id;
    private Connection connection;

    public CityCallable(String city_id, Connection connection) {
        this.city_id = city_id;
        this.connection = connection;
    }

    @Override
    public String call() throws Exception {
        return findCity(city_id,connection);
    }

    private String findCity(String city_id, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(String.format("select id from %s where tag_id = '%s'",
                StaticTable.API_CITY,
                city_id));
        String result = "";
        if(resultSet.next()){
            result = resultSet.getString(1);
        }
        JDBCUtils.close(null,statement,resultSet);
        return result;
    }
}
