package com.gmei.callable;

import com.gmei.bean.PromotionChannelInfo;
import com.gmei.bean.StaticTable;
import com.gmei.utils.JDBCUtils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.Callable;

/**
 * ClassName: com.gmei.callable.PromotionChannelCallable
 * Function: TODO ADD FUNCTION.
 * Reason: 查询ios设备渠道信息
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class PromotionChannelCallable implements Callable<PromotionChannelInfo>{
    private String device_id;
    private Connection connection;
    private String today;
    private String tomorrow;

    public PromotionChannelCallable(String device_id, Connection connection, String today, String tomorrow) {
        this.device_id = device_id;
        this.connection = connection;
        this.today = today;
        this.tomorrow = tomorrow;
    }

    @Override
    public PromotionChannelInfo call() throws Exception {
        return findDevicePromotion(device_id,connection,today,tomorrow);
    }

    private PromotionChannelInfo findDevicePromotion(String deviceId,Connection connection,String today,String tomorrow) throws Exception{
        if(deviceId == null || deviceId.trim().length() == 0){
            return null;
        }
        deviceId = deviceId.trim();

        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(
//                select active_time, appid from %s where idfa = '%s' and active_time is not null limit 1
                String.format(
                        "select idfa as device_id," +
                                "'ios' as platform," +
                                "appid as channel," +
                                "date_format(active_time,'%%Y-%%m-%%d %%H:%%i:%%s') as created_time " +
                                "from %s " +
                                "where idfa = '%s' " +
                                "and platform_type = 1 " +
                                "and active_time is not null " +
                                "and date_format(active_time,'%%Y-%%m-%%d %%H:%%i:%%s') >= '%s' " +
                                "and date_format(active_time,'%%Y-%%m-%%d %%H:%%i:%%s') < '%s' " +
                                "order by active_time,id limit 1 ",
                        StaticTable.PROMOTIONCHANNEL,
                        deviceId,
                        today,
                        tomorrow
                )
        );
        PromotionChannelInfo devicePromotionInfo = new PromotionChannelInfo();
        while (resultSet.next()){
            devicePromotionInfo.setDevice_id(resultSet.getString(1));
            devicePromotionInfo.setPlatform(resultSet.getString(2));
            devicePromotionInfo.setChannel(resultSet.getString(3));
            devicePromotionInfo.setActive_time(resultSet.getString(4));
        }

        JDBCUtils.close(null,statement,resultSet);
        return devicePromotionInfo;
    }
}
