package com.gmei.sink;

import com.gmei.bean.*;
import com.gmei.cache.SimpleCacheService;
import com.gmei.callable.*;
import com.gmei.utils.JDBCUtils;
import com.gmei.utils.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * ClassName: com.gmei.sink.KafkaSink
 * Function: TODO ADD FUNCTION.
 * Reason: 对后端埋点进行Etl并获取活跃设备第一次活跃信息-数据输出(实时)
 * Date: 2020-03-03 00:00:00
 *
 * @author sjxuwei
 * @since JDK 1.8
 */
public class KafkaSink extends RichSinkFunction<BackendEtl>{
    private int maxRetry = 1;
    private long retryInteral = 3000;
    private String zxJdbcUrl;
    private String outJdbcUrl;
    private String outTable;
    private Connection zxConnection;
    private Connection outConnection;
    private SimpleDateFormat simpleDateFormat;
    private SimpleDateFormat simpleDateFormat2;

    //声明缓存池
    private  SimpleCacheService<String,Boolean> doctorChache;
    private  SimpleCacheService<String, DeviceInfo> deviceCache;
    private  SimpleCacheService<String, PromotionChannelInfo> promotionChannelCache;
    private  SimpleCacheService<String,BackendDevice> deviceUpdateCache;
    private  SimpleCacheService<String,String> cityCache;
    private Calendar calendar;

    public KafkaSink(String zxJdbcUrl, String outJdbcUrl, String outTable) {
        this.zxJdbcUrl = zxJdbcUrl;
        this.outJdbcUrl = outJdbcUrl;
        this.outTable = outTable;
    }

    @Override
    public  void invoke(BackendEtl value, Context context) throws Exception {
        try {
            execute(value);
        }catch (Exception e){
            int numReties = 1;
            Exception lastException = e;
            while (numReties <= maxRetry){
                try {
                    numReties++;
                    Thread.sleep(retryInteral);
                    closeConn();
                    init();
                    e.printStackTrace();
                    System.out.println("retry++++++++++++++++++++++");
                    execute(value);
                }catch (Exception e1){
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }

    /**
    * Function: TODO ADD FUNCTION.
    * Reason: sink输出处理主逻辑.
    * Date:  2020-03-03 00:00:00
    *
    * @author sjxuwei
    * @since JDK 1.8
    */
    private  void execute(BackendEtl value) throws SQLException {
        String city_id = value.getCity_id();
        String id = cityCache.getValue(city_id,new CityCallable(city_id,zxConnection));
        if(id.length() > 0){
            city_id = id;
        }
        value.setCity_id(city_id);
        long time_str = Long.parseLong(value.getTime_str());
        String time_string = String.valueOf(time_str);
        Date current_date = new Date(time_str);
        calendar.setTime(current_date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date todayTimeOrigin = new Date(calendar.getTime().getTime());
        calendar.add(calendar.DATE,1);
        String tomorrow = simpleDateFormat.format(calendar.getTime());
        String today = simpleDateFormat.format(todayTimeOrigin);
        //当天0点日期
        String device_id = value.getCl_id();
        String user_id = value.getUser_id();
        BackendDevice old_data = deviceUpdateCache.getValue(device_id + "_" + simpleDateFormat2.format(current_date), new DeviceUpdateCallable(device_id, outConnection, outTable,simpleDateFormat2.format(current_date)));
        PromotionChannelInfo promotionChannelInfo = promotionChannelCache.getValue(device_id + "_" + simpleDateFormat2.format(current_date), new PromotionChannelCallable(device_id, zxConnection, today, tomorrow));
        //默认数据是按照时间顺序过来的，那么当设备第一次出现是需要判断当前设备是新活还是老活
        //如果是新活，那么将first和history_first的数据保持一致即可
        //如果是老活，那么新活的数据优先取埋点内的数据，老活的数据优先取device和promotion中的数据
        DeviceInfo deviceInfo = deviceCache.getValue(device_id + "_" + simpleDateFormat2.format(current_date), new DeviceCallable(device_id, zxConnection, today, tomorrow));
        String first_visit_time_today = "";
        String history_first_visit_time = "";
        String first_user_id_today = "";
        String user_id_time = "";
        String history_first_user_id = "";
        String first_city_id_today = "";
        String city_id_time = "";
        String history_first_city_id = "";
        String first_channel_today = "";
        String channel_time = "";
        String history_first_channel = "";
        String first_platform_today = "";
        String platform_time = "";
        String history_first_platform = "";
        String first_os_version_today = "";
        String os_version_time = "";
        String history_firest_os_version = "";
        String first_app_version_today = "";
        String app_version_time = "";
        String history_first_app_version = "";
        String model = "";
        String screen = "";
        String history_user_id_time = "";
        String history_city_id_time = "";
        String history_channel_time = "";
        String history_platform_time ="";
        String history_os_version_time = "";
        String history_app_version_time = "";

        String is_doctor =  (doctorChache.getValue(user_id, new DoctorCallable(user_id, zxConnection)) ? "1" : "0");
        try {
            long last_activity = Long.MAX_VALUE;
            if(deviceInfo.getLast_activity() != null){
                last_activity = simpleDateFormat.parse(deviceInfo.getLast_activity()).getTime();
            }

            /*
               对于一个设备有几种情况
               1、新增设备
               2、老活设备并且当天已经出现过访问记录
               3、老活设备并且当前数据是这个设备当天的第1条数据
             */
            if(old_data.getFirst_visit_time_today() == null){
                //对新增设备进行处理
                first_visit_time_today = simpleDateFormat.format(current_date);
                history_first_visit_time = first_visit_time_today;

                first_channel_today = StringUtils.getNotNull(promotionChannelInfo.getChannel(),deviceInfo.getChannel(),value.getChannel());
                history_first_channel = first_channel_today;

                first_platform_today = StringUtils.getNotNull(deviceInfo.getPlatform(),promotionChannelInfo.getPlatform(),value.getCl_type());
                history_first_platform = first_platform_today;

                List<VersionBean> osVersionList = new ArrayList<>();
                osVersionList.add(new VersionBean(deviceInfo.getOs_version(),last_activity));
                osVersionList.add(new VersionBean(value.getCl_os_version(),time_str));
                Collections.sort(osVersionList);
                for(VersionBean version : osVersionList){
                    if(version.getVersion() != null && version.getVersion().length() > 0){
                        first_os_version_today = version.getVersion();
                        os_version_time = String.valueOf(version.getTime());
                        break;
                    }
                }
                if(os_version_time.length() == 0){
                    os_version_time = String.valueOf(osVersionList.get(0).getTime());
                }

                List<VersionBean> versionList = new ArrayList<>();
                versionList.add(new VersionBean(deviceInfo.getVersion(),last_activity));
                versionList.add(new VersionBean(value.getApp_version(),time_str));
                Collections.sort(versionList);
                for(VersionBean version : versionList){
                    if(version.getVersion() != null && version.getVersion().length() > 0){
                        first_app_version_today = version.getVersion();
                        app_version_time = String.valueOf(version.getTime());
                        break;
                    }
                }
                if(app_version_time.length() == 0){
                    app_version_time = String.valueOf(versionList.get(0).getTime());
                }

                history_firest_os_version = first_os_version_today;
                history_first_app_version = first_app_version_today;

                first_city_id_today = value.getCity_id();
                history_first_city_id = first_city_id_today;

                first_user_id_today = value.getUser_id();
                history_first_user_id = first_user_id_today;

                model = StringUtils.getNotNull(old_data.getModel(),deviceInfo.getModel());
                screen = StringUtils.getNotNull(old_data.getScreen(),deviceInfo.getScreen());
                BackendDevice new_data = new BackendDevice(
                        device_id,
                        first_visit_time_today,
                        history_first_visit_time,
                        first_user_id_today,
                        time_string,
                        history_first_user_id,
                        first_city_id_today,
                        time_string,
                        history_first_city_id,
                        first_channel_today,
                        time_string,
                        history_first_channel,
                        first_platform_today,
                        time_string,
                        history_first_platform,
                        first_os_version_today,
                        String.valueOf(os_version_time),
                        history_firest_os_version,
                        first_app_version_today,
                        String.valueOf(app_version_time),
                        history_first_app_version,
                        model,
                        screen,
                        (old_data.getIs_doctor() == null || old_data.getIs_doctor().equals("0")) ? is_doctor : old_data.getIs_doctor(),
                        simpleDateFormat2.format(current_date),
                        time_string,
                        time_string,
                        time_string,
                        time_string,
                        String.valueOf(os_version_time),
                        String.valueOf(app_version_time));
                deviceUpdateCache.putValue(device_id + "_" + simpleDateFormat2.format(current_date),new_data);
                insert(outConnection, new_data);
            }else{
                if(org.apache.commons.lang3.time.DateUtils.isSameDay(current_date,simpleDateFormat.parse(old_data.getFirst_visit_time_today()))){
                    //对老活设备并且当天已经出现过访问记录的设备进行处理
                    //除了时间以外，需要更新其他长度为0的字段
                    first_visit_time_today = old_data.getFirst_visit_time_today();
                    long old_time = simpleDateFormat.parse(first_visit_time_today).getTime();
                    if(time_str < old_time){
                        first_visit_time_today = simpleDateFormat.format(new Date(time_str));
                    }

                    if(time_str < Long.parseLong(old_data.getChannel_time())){
                        first_channel_today = StringUtils.getNotNull(promotionChannelInfo.getChannel(), deviceInfo.getChannel(),  value.getChannel(),old_data.getFirst_channel_today());
                        if(first_channel_today.equals(value.getChannel()) || first_channel_today.equals(promotionChannelInfo.getChannel()) || first_channel_today.equals(deviceInfo.getChannel())){
                            channel_time = String.valueOf(time_str);
                        }else{
                            channel_time = old_data.getChannel_time();
                        }
                    }else{
                        first_channel_today = StringUtils.getNotNull(promotionChannelInfo.getChannel(), deviceInfo.getChannel(), old_data.getFirst_channel_today(), value.getChannel());
                        if(first_channel_today.equals(old_data.getFirst_channel_today()) || first_channel_today.equals(promotionChannelInfo.getChannel()) || first_channel_today.equals(deviceInfo.getChannel())){
                            channel_time = old_data.getChannel_time();
                        }else{
                            channel_time = String.valueOf(time_str);
                        }
                    }

                    if(time_str < Long.parseLong(old_data.getPlatform_time())){
                        first_platform_today = StringUtils.getNotNull(deviceInfo.getPlatform(), promotionChannelInfo.getPlatform(), value.getCl_type(),old_data.getFirst_platform_today());
                        if(first_platform_today.equals(value.getCl_type()) || first_platform_today.equals(deviceInfo.getPlatform()) || first_platform_today.equals(promotionChannelInfo.getPlatform())){
                            platform_time = String.valueOf(time_str);
                        }else{
                            platform_time = old_data.getPlatform_time();
                        }
                    }else{
                        first_platform_today = StringUtils.getNotNull(deviceInfo.getPlatform(), promotionChannelInfo.getPlatform(), old_data.getFirst_platform_today(), value.getCl_type());
                        if(first_platform_today.equals(old_data.getFirst_platform_today()) || first_platform_today.equals(deviceInfo.getPlatform()) || first_platform_today.equals(promotionChannelInfo.getPlatform())){
                            platform_time = old_data.getPlatform_time();

                        }else{
                            platform_time = String.valueOf(time_str);
                        }
                    }


                    List<VersionBean> osVersionList = new ArrayList<>();
                    osVersionList.add(new VersionBean(deviceInfo.getOs_version(),last_activity));
                    osVersionList.add(new VersionBean(old_data.getFirst_os_version_today(),Long.parseLong(old_data.getOs_version_time())));
                    osVersionList.add(new VersionBean(value.getCl_os_version(),time_str));
                    Collections.sort(osVersionList);
                    for(VersionBean version : osVersionList){
                        if(version.getVersion() != null && version.getVersion().length() > 0){
                            first_os_version_today = version.getVersion();
                            os_version_time = String.valueOf(version.getTime());
                            break;
                        }
                    }
                    if(os_version_time.length() == 0){
                        os_version_time = String.valueOf(osVersionList.get(0).getTime());
                    }

                    List<VersionBean> versionList = new ArrayList<>();
                    versionList.add(new VersionBean(deviceInfo.getVersion(),last_activity));
                    versionList.add(new VersionBean(old_data.getFirst_app_version_today(),Long.parseLong(old_data.getApp_verison_time())));
                    versionList.add(new VersionBean(value.getApp_version(),time_str));
                    Collections.sort(versionList);
                    for(VersionBean version : versionList){
                        if(version.getVersion() != null && version.getVersion().length() > 0){
                            first_app_version_today = version.getVersion();
                            app_version_time = String.valueOf(version.getTime());
                            break;
                        }
                    }
                    if(app_version_time.length() == 0){
                        app_version_time = String.valueOf(versionList.get(0).getTime());
                    }

                    if(time_str < Long.parseLong(old_data.getCity_id_time())){
                        first_city_id_today = StringUtils.getNotNull(value.getCity_id(),old_data.getFirst_city_id_today());
                        if(first_city_id_today.equals(value.getCity_id())){
                            city_id_time = String.valueOf(time_str);
                        }else{
                            city_id_time = old_data.getCity_id_time();
                        }
                    }else{
                        first_city_id_today = StringUtils.getNotNull(old_data.getFirst_city_id_today(), value.getCity_id());
                        if(first_city_id_today.equals(old_data.getFirst_city_id_today())){
                            city_id_time = old_data.getCity_id_time();
                        }else{
                            city_id_time = String.valueOf(time_str);
                        }
                    }

                    if(time_str < Long.parseLong(old_data.getUser_id_time())){
                        first_user_id_today = StringUtils.getNotNull(value.getUser_id(),old_data.getFirst_user_id_today());
                        if(first_user_id_today.equals(value.getUser_id())){
                            user_id_time = String.valueOf(time_str);
                        }else{
                            user_id_time = old_data.getUser_id_time();
                        }
                    }else{
                        first_user_id_today = StringUtils.getNotNull(old_data.getFirst_user_id_today(), value.getUser_id());
                        if(first_user_id_today.equals(old_data.getFirst_user_id_today())){
                            user_id_time = old_data.getUser_id_time();
                        }else{
                            user_id_time = String.valueOf(time_str);
                        }
                    }

                    if(!old_data.getFirst_visit_time_today().equals(old_data.getHistory_first_visit_time())) {
                        //此设备是老活设备
                        //当天首次浏览时间
                        history_first_visit_time = old_data.getHistory_first_visit_time();

                        history_first_channel = StringUtils.getNotNull(old_data.getHistory_first_channel(),first_channel_today);
                        if(history_first_channel.equals(old_data.getHistory_first_channel())){
                            history_channel_time = old_data.getHistory_channel_time();
                        }else{
                            history_channel_time = time_string;
                        }

                        history_first_platform = StringUtils.getNotNull(old_data.getHistory_first_platform(),first_platform_today);
                        if(history_first_platform.equals(old_data.getHistory_first_platform())){
                            history_platform_time = old_data.getHistory_platform_time();
                        }else{
                            history_platform_time = time_string;
                        }

                        history_firest_os_version = StringUtils.getNotNull(old_data.getHistory_firest_os_version(),first_os_version_today);
                        if(history_firest_os_version.equals(old_data.getHistory_firest_os_version())){
                            history_os_version_time = old_data.getHistory_os_version_time();
                        }else{
                            history_os_version_time = time_string;
                        }

                        history_first_app_version = StringUtils.getNotNull(old_data.getHistory_first_app_version(),first_app_version_today);
                        if(history_first_app_version.equals(old_data.getHistory_first_app_version())){
                            history_app_version_time = old_data.getHistory_app_version_time();
                        }else{
                            history_app_version_time = time_string;
                        }

                        history_first_city_id = StringUtils.getNotNull(old_data.getHistory_first_city_id(),first_city_id_today);
                        if(history_first_city_id.equals(old_data.getHistory_first_city_id())){
                            history_city_id_time = old_data.getHistory_city_id_time();
                        }else{
                            history_city_id_time = time_string;
                        }

                        history_first_user_id = StringUtils.getNotNull(old_data.getHistory_first_user_id(),first_user_id_today);
                        if(history_first_user_id.equals(old_data.getHistory_first_user_id())){
                            history_user_id_time = old_data.getHistory_user_id_time();
                        }else{
                            history_user_id_time = time_string;
                        }
                    }else{
                        //此设备是当天活跃设备,所以第一次和历史第一次的数据应该是一致的
                        history_first_visit_time = first_visit_time_today;
                        history_first_channel = first_channel_today;
                        history_channel_time = channel_time;
                        history_first_platform = first_platform_today;
                        history_platform_time = platform_time;
                        history_firest_os_version = first_os_version_today;
                        history_os_version_time = os_version_time;
                        history_first_app_version = first_app_version_today;
                        history_app_version_time = app_version_time;
                        history_first_city_id = first_city_id_today;
                        history_city_id_time = city_id_time;
                        history_first_user_id = first_user_id_today;
                        history_user_id_time = user_id_time;
                    }

                    model = StringUtils.getNotNull(old_data.getModel(),deviceInfo.getModel());
                    screen = StringUtils.getNotNull(old_data.getScreen(),deviceInfo.getScreen());

                    BackendDevice new_data = new BackendDevice(
                                device_id,
                                first_visit_time_today,
                                history_first_visit_time,
                                first_user_id_today,
                                user_id_time,
                                history_first_user_id,
                                first_city_id_today,
                                city_id_time,
                                history_first_city_id,
                                first_channel_today,
                                channel_time,
                                history_first_channel,
                                first_platform_today,
                                platform_time,
                                history_first_platform,
                                first_os_version_today,
                                os_version_time,
                                history_firest_os_version,
                                first_app_version_today,
                                app_version_time,
                                history_first_app_version,
                                model,
                                screen,
                                (old_data.getIs_doctor() == null || old_data.getIs_doctor().equals("0")) ? is_doctor : old_data.getIs_doctor(),
                                simpleDateFormat2.format(current_date),
                                history_user_id_time,
                            history_city_id_time,
                            history_channel_time,
                            history_platform_time,
                            history_os_version_time,
                            history_app_version_time);
                    deviceUpdateCache.putValue(device_id + "_" + simpleDateFormat2.format(current_date),new_data);
                    insert(outConnection,new_data);
                }else{
                    //对老活设备并且当前数据是这个设备当天的第1条数据的设备进行处理
                    //需要插入而不是更新
                    first_visit_time_today = simpleDateFormat.format(current_date);

                    first_channel_today = StringUtils.getNotNull(promotionChannelInfo.getChannel(),deviceInfo.getChannel(),value.getChannel());
                    first_platform_today = StringUtils.getNotNull(deviceInfo.getPlatform(),promotionChannelInfo.getPlatform(),value.getCl_type());


                    List<VersionBean> osVersionList = new ArrayList<>();
                    osVersionList.add(new VersionBean(deviceInfo.getOs_version(),last_activity));
                    osVersionList.add(new VersionBean(value.getCl_os_version(),time_str));
                    Collections.sort(osVersionList);
                    for(VersionBean version : osVersionList){
                        if(version.getVersion() != null && version.getVersion().length() > 0){
                            first_os_version_today = version.getVersion();
                            os_version_time = String.valueOf(version.getTime());
                            break;
                        }
                    }
                    if(os_version_time.length() == 0){
                        os_version_time = String.valueOf(osVersionList.get(0).getTime());
                    }

                    List<VersionBean> versionList = new ArrayList<>();
                    versionList.add(new VersionBean(deviceInfo.getVersion(),last_activity));
                    versionList.add(new VersionBean(value.getApp_version(),time_str));
                    Collections.sort(versionList);
                    for(VersionBean version : versionList){
                        if(version.getVersion() != null && version.getVersion().length() > 0){
                            first_app_version_today = version.getVersion();
                            app_version_time = String.valueOf(version.getTime());
                            break;
                        }
                    }
                    if(app_version_time.length() == 0){
                        app_version_time = String.valueOf(versionList.get(0).getTime());
                    }

                    first_city_id_today = value.getCity_id();
                    first_user_id_today = value.getUser_id();

                    history_first_visit_time = old_data.getHistory_first_visit_time();

                    history_first_channel = StringUtils.getNotNull(old_data.getHistory_first_channel(),first_channel_today);
                    if(history_first_channel.equals(old_data.getHistory_first_channel())){
                        history_channel_time = old_data.getHistory_channel_time();
                    }else{
                        history_channel_time = time_string;
                    }

                    history_first_platform = StringUtils.getNotNull(old_data.getHistory_first_platform(),first_platform_today);
                    if(history_first_platform.equals(old_data.getHistory_first_platform())){
                        history_platform_time = old_data.getHistory_platform_time();
                    }else{
                        history_platform_time = time_string;
                    }

                    history_firest_os_version = StringUtils.getNotNull(old_data.getHistory_firest_os_version(),first_os_version_today);
                    if(history_firest_os_version.equals(old_data.getHistory_firest_os_version())){
                        history_os_version_time = old_data.getHistory_os_version_time();
                    }else{
                        history_os_version_time = time_string;
                    }

                    history_first_app_version = StringUtils.getNotNull(old_data.getHistory_first_app_version(),first_app_version_today);
                    if(history_first_app_version.equals(old_data.getHistory_first_app_version())){
                        history_app_version_time = old_data.getHistory_app_version_time();
                    }else{
                        history_app_version_time = time_string;
                    }

                    history_first_city_id = StringUtils.getNotNull(old_data.getHistory_first_city_id(),first_city_id_today);
                    if(history_first_city_id.equals(old_data.getHistory_first_city_id())){
                        history_city_id_time = old_data.getHistory_city_id_time();
                    }else{
                        history_city_id_time = time_string;
                    }

                    history_first_user_id = StringUtils.getNotNull(old_data.getHistory_first_user_id(),first_user_id_today);
                    if(history_first_user_id.equals(old_data.getHistory_first_user_id())){
                        history_user_id_time = old_data.getHistory_user_id_time();
                    }else{
                        history_user_id_time = time_string;
                    }

                    model = StringUtils.getNotNull(old_data.getModel(),deviceInfo.getModel());
                    screen = StringUtils.getNotNull(old_data.getScreen(),deviceInfo.getScreen());

                    BackendDevice new_data = new BackendDevice(
                            device_id,
                            first_visit_time_today,
                            history_first_visit_time,
                            first_user_id_today,
                            String.valueOf(time_str),
                            history_first_user_id,
                            first_city_id_today,
                            String.valueOf(time_str),
                            history_first_city_id,
                            first_channel_today,
                            String.valueOf(time_str),
                            history_first_channel,
                            first_platform_today,
                            String.valueOf(time_str),
                            history_first_platform,
                            first_os_version_today,
                            String.valueOf(os_version_time),
                            history_firest_os_version,
                            first_app_version_today,
                            String.valueOf(app_version_time),
                            history_first_app_version,
                            model,
                            screen,
                            (old_data.getIs_doctor().equals("0") ? is_doctor : old_data.getIs_doctor()),
                            simpleDateFormat2.format(current_date),
                            history_user_id_time,
                            history_city_id_time,
                            history_channel_time,
                            history_platform_time,
                            history_os_version_time,
                            history_app_version_time);
                    deviceUpdateCache.putValue(device_id + "_" + simpleDateFormat2.format(current_date),new_data);
                    insert(outConnection, new_data);
                }
            }
            if(promotionChannelInfo.getDevice_id() == null){
                promotionChannelCache.invalidate(device_id + "_" + simpleDateFormat2.format(current_date));
            }
            if(deviceInfo.getDevice_id() == null){
                deviceCache.invalidate(device_id + "_" + simpleDateFormat2.format(current_date));
            }
        } catch (ParseException e) {
            throw new RuntimeException("time format error:" + e.getMessage());
        }
    }

    /**
    * Function: TODO ADD FUNCTION.
    * Reason: 插入活跃设备数据（有则更新无则插入）
    * Date:  2020-03-03 00:00:00
    *
    * @author sjxuwei
    * @since JDK 1.8
    */
    private void insert(Connection outConnection, BackendDevice result) throws SQLException {
        Statement statement = outConnection.createStatement();
        statement.executeUpdate(String.format("INSERT INTO %s(" +
                        "device_id," +
                "first_visit_time_today," +
                "history_first_visit_time," +
                "first_user_id_today," +
                "user_id_time," +
                "history_first_user_id," +
                "first_city_id_today," +
                "city_id_time," +
                "history_first_city_id," +
                "first_channel_today," +
                "channel_time," +
                "history_first_channel," +
                "first_platform_today," +
                "platform_time," +
                "history_first_platform," +
                "first_os_version_today," +
                "os_version_time," +
                "history_firest_os_version," +
                "first_app_version_today," +
                "app_version_time," +
                "history_first_app_version," +
                "model," +
                "screen," +
                "is_doctor," +
                "date," +
                        "history_user_id_time," +
                        "history_city_id_time," +
                        "history_channel_time," +
                        "history_platform_time," +
                        "history_os_version_time," +
                        "history_app_version_time) VALUE('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s') " +
                        "ON DUPLICATE KEY UPDATE " +
                        "device_id = '%s'," +
                        "first_visit_time_today = '%s'," +
                        "history_first_visit_time = '%s'," +
                        "first_user_id_today = '%s'," +
                        "user_id_time = '%s'," +
                        "history_first_user_id = '%s'," +
                        "first_city_id_today = '%s'," +
                        "city_id_time = '%s'," +
                        "history_first_city_id = '%s'," +
                        "first_channel_today = '%s'," +
                        "channel_time = '%s'," +
                        "history_first_channel = '%s'," +
                        "first_platform_today = '%s'," +
                        "platform_time = '%s'," +
                        "history_first_platform = '%s'," +
                        "first_os_version_today = '%s'," +
                        "os_version_time = '%s'," +
                        "history_firest_os_version = '%s'," +
                        "first_app_version_today = '%s'," +
                        "app_version_time = '%s'," +
                        "history_first_app_version = '%s'," +
                        "model = '%s'," +
                        "screen = '%s'," +
                        "is_doctor = '%s'," +
                        "date = '%s'," +
                        "history_user_id_time = '%s'," +
                        "history_city_id_time = '%s'," +
                        "history_channel_time = '%s'," +
                        "history_platform_time = '%s'," +
                        "history_os_version_time= '%s'," +
                        "history_app_version_time = '%s'",
                outTable,
                result.getDevice_id(),
                result.getFirst_visit_time_today(),
                result.getHistory_first_visit_time(),
                result.getFirst_user_id_today(),
                result.getUser_id_time(),
                result.getHistory_first_user_id(),
                result.getFirst_city_id_today(),
                result.getCity_id_time(),
                result.getHistory_first_city_id(),
                result.getFirst_channel_today(),
                result.getChannel_time(),
                result.getHistory_first_channel(),
                result.getFirst_platform_today(),
                result.getPlatform_time(),
                result.getHistory_first_platform(),
                result.getFirst_os_version_today(),
                result.getOs_version_time(),
                result.getHistory_firest_os_version(),
                result.getFirst_app_version_today(),
                result.getApp_verison_time(),
                result.getHistory_first_app_version(),
                result.getModel(),
                result.getScreen(),
                result.getIs_doctor(),
                result.getDate(),
                result.getHistory_user_id_time(),
                result.getHistory_city_id_time(),
                result.getHistory_channel_time(),
                result.getHistory_platform_time(),
                result.getHistory_os_version_time(),
                result.getHistory_app_version_time(),
                result.getDevice_id(),
                result.getFirst_visit_time_today(),
                result.getHistory_first_visit_time(),
                result.getFirst_user_id_today(),
                result.getUser_id_time(),
                result.getHistory_first_user_id(),
                result.getFirst_city_id_today(),
                result.getCity_id_time(),
                result.getHistory_first_city_id(),
                result.getFirst_channel_today(),
                result.getChannel_time(),
                result.getHistory_first_channel(),
                result.getFirst_platform_today(),
                result.getPlatform_time(),
                result.getHistory_first_platform(),
                result.getFirst_os_version_today(),
                result.getOs_version_time(),
                result.getHistory_firest_os_version(),
                result.getFirst_app_version_today(),
                result.getApp_verison_time(),
                result.getHistory_first_app_version(),
                result.getModel(),
                result.getScreen(),
                result.getIs_doctor(),
                result.getDate(),
                result.getHistory_user_id_time(),
                result.getHistory_city_id_time(),
                result.getHistory_channel_time(),
                result.getHistory_platform_time(),
                result.getHistory_os_version_time(),
                result.getHistory_app_version_time()));
        JDBCUtils.close(null,statement,null);
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        init();
        super.open(parameters);
    }

    @Override
    public void close() throws Exception {
        closeConn();
        super.close();
    }

    private void closeConn() throws SQLException {
        JDBCUtils.close(zxConnection,null,null);
        JDBCUtils.close(outConnection,null,null);
    }

    /**
    * Function: TODO ADD FUNCTION.
    * Reason: sink变量初始化
    * Date:  2020-03-03 00:00:00
    *
    * @author sjxuwei
    * @since JDK 1.8
    */
    private void init() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        zxConnection = DriverManager.getConnection(zxJdbcUrl);
        outConnection = DriverManager.getConnection(outJdbcUrl);
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        calendar = Calendar.getInstance();
        doctorChache = new SimpleCacheService<>(6000,2);
        deviceCache = new SimpleCacheService<>(100000,2);
        promotionChannelCache = new SimpleCacheService<>(100000,2);
        deviceUpdateCache = new SimpleCacheService<>(100000,2);
        cityCache = new SimpleCacheService<>(6000,2);
    }
}
