package com.gmei.utils;

import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;

public class GmKafkaConsumer {
    private String topic;
    private Properties prop;
    private FlinkKafkaConsumer flinkKafkaConsumer;

    public GmKafkaConsumer(String topic) {
        this.topic = topic;
        this.prop = new Properties();
    }

    public void setSource(DeserializationSchema<String> schema) throws ParseException {
        this.flinkKafkaConsumer = new FlinkKafkaConsumer<String>(topic,schema,this.prop);
    }

    public FlinkKafkaConsumer getSource(){
        return this.flinkKafkaConsumer;
    }

    public void setProp(String key,String value){
        prop.setProperty(key,value);
    }
}
