import path_setting
from in_common.base_request import BaseRequest


class tractate_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.TRACTATE_CONFIG)

    # 帖子详情页内容
    def tractate_detail(self, current_city_id, tractate_id, data_type):
        self.params["current_city_id"] = current_city_id
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["tractate_detail"])

    # 帖子相关美购
    def tractate_related_service(self, current_city_id, tractate_id, data_type):
        self.params["current_city_id"] = current_city_id
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["related_service"])

    # 帖子外显评论
    def reply(self, current_city_id, id, data_type):
        self.params["current_city_id"] = current_city_id
        self.params["id"] = id
        self.params["data_type"] = data_type
        return self.api_send(self.data["reply"])

    # 帖子点赞
    def favor(self, tractate_id, data_type):
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["favor"])

    # 帖子取消点赞
    def cancelfavor(self, tractate_id, data_type):
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["cancelfavor"])





