import path_setting
from in_common.base_request import BaseRequest


class web_request(BaseRequest):
    def __init__(self):
        self.ACCOUNT_URL = self.api_load(path_setting.ACCOUNT_URL)

    def account_unreadbadgecount(self) :
        return self.api_send(self.ACCOUNT_URL["account_unreadbadgecount"])

    def article_videotoken(self) :
        return self.api_send(self.ACCOUNT_URL["article_videotoken"])

    def doctor_submechanisms(self) :
        return self.api_send(self.ACCOUNT_URL["doctor_submechanisms"])

    def service_offline(self,id,csrfmiddlewaretoken):
        self.params["id"] = id
        self.params["csrfmiddlewaretoken"] = csrfmiddlewaretoken
        return self.api_send(self.ACCOUNT_URL["service_offline"])

    def conversation(self, is_star, page):
        self.params["is_star"] = is_star
        self.params["page"] = page
        return self.api_send(self.ACCOUNT_URL["conversation"])

    def conversation_unread_list(self, page):
        self.params["page"] = page
        return self.api_send(self.ACCOUNT_URL["conversation_unread_list"])

    def service(self):
        return self.api_send(self.ACCOUNT_URL["service"])

    def conversation_diary(self, doctor_user_id):
        self.params["doctor_user_id"] = doctor_user_id
        return self.api_send(self.ACCOUNT_URL["conversation_diary"])

    def conversation_coupon(self, doctor_user_id):
        self.params["doctor_user_id"] = doctor_user_id
        return self.api_send(self.ACCOUNT_URL["conversation_coupon"])

    def service_all(self):
        return self.api_send(self.ACCOUNT_URL["service_all"])

    def conversation_user_id(self, type, content, doctor_user_id, t, csrfmiddlewaretoken):
        self.params["type"] = type
        self.params["content"] = content
        self.params["doctor_user_id"] = doctor_user_id
        self.params["t"] = t
        self.params["csrfmiddlewaretoken"] = csrfmiddlewaretoken
        return self.api_send(self.ACCOUNT_URL["conversation_user_id"])

    # def file_upload(self, img_type,csrfmiddlewaretoken,id,name,type,lastModifiedDate,size,file):
    #     self.params["img_type"] = img_type
    #     self.params["csrfmiddlewaretoken"] = csrfmiddlewaretoken
    #     self.params["id"] = id
    #     self.params["name"] = name
    #     self.params["type"] = type
    #     self.params["lastModifiedDate"] = lastModifiedDate
    #     self.params["size"] = size
    #     self.params["file"] = file
    #     return self.api_send(self.ACCOUNT_URL["file_upload"])
    def cpc_homepage(self):
        return self.api_send(self.ACCOUNT_URL["cpc_homepage"])
    def artemis_ad_type_list(self):
        return self.api_send(self.ACCOUNT_URL["artemis_ad_type_list"])
    def artemis_order_list(self,status):
        self.params["status"] = status
        return self.api_send(self.ACCOUNT_URL["artemis_order_list"])





if __name__ == '__main__':
    print(web_request().account_unreadbadgecount())
    print(web_request().article_videotoken())
    print(web_request().doctor_submechanisms())
    print(web_request().service_offline("209992", "PC8uTySuxipukIMuqNV1OPB376C2ZZ3g"))
    print(web_request().conversation(0, 1))
    print(web_request().conversation_unread_list(1))
    print(web_request().service())
    print(web_request().conversation_diary(602329))
    print(web_request().conversation_coupon(602329))
    print(web_request().service_all())
    # print(web_request().file_upload("19","PC8uTySuxipukIMuqNV1OPB376C2ZZ3g","WU_FILE_0","lADPDg7mQdiUTiLNAZDNAZA_400_400.jpg_720x720g.jpg","image/jpeg","Mon Apr 26 2021 11:29:45 GMT+0800 (中国标准时间)","17688","(binary)"))
    print(web_request().conversation_user_id(0, "您好", 602329, "271caac2ae1687ca0a56ee18115b8183", "NLeTxEx1BOQo1zjv2us9BQ00ViMAHGpJ"))
    print(web_request().cpc_homepage())
    print(web_request().artemis_ad_type_list())
    print("发送")
    print(web_request().artemis_order_list(0))
    print(web_request().artemis_order_list(1))
    print(web_request().artemis_order_list(2))