import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.common_request import common_request


class TestRrplySubReply:
    data = BaseRequest().api_load(path_setting.TOPIC_SUB_COMMON)
    topic_sub_common_case, topic_sub_common_data = get_ids(data, "topic_sub_common")

    @pytest.mark.parametrize("param", topic_sub_common_data, ids=topic_sub_common_case)
    def test_reply_sub_reply(self, param):
        # print(2)
        r = common_request().topic_sub_common(param["id"], param["type"], param["reply_id"])
        # print(r)
        if r["error"] == 0:
            assert r["error"] == param["assert1"]
            # 先判断有没有评论，然后判断里面需要的那些字段，如点赞字段，评论总数等，不传值，传空值
            if r["data"]:
                assert r["data"][0]["at_user_id"] is not None and r["data"][0]["at_user_id"] is not ""  # 用户id
                assert r["data"][0]["comment_user_gm_url"] is not None and r["data"][0]["comment_user_gm_url"] is not ""  # 点击评论跳转链接
                assert r["data"][0]["at_user_gm_url"] is not None and r["data"][0]["at_user_gm_url"] is not ""  # 用户名跳转链接
                assert r["data"][0]["nickname"] is not None and r["data"][0]["nickname"] is not ""  # 用户名
                assert r["data"][0]["content"] is not None and r["data"][0]["content"] is not ""  # 评论内容
                assert r["data"][0]["comment_user_id"] is not None and r["data"][0]["comment_user_id"] is not ""  # 评论人
                assert r["data"][0]["comment_id"] is not None and r["data"][0]["comment_id"] is not ""  # 评论id
                assert r["data"]["reply_data"][0]["_type"] == param["type"]  # 校验评论列表返回类型





