import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestFreeRecruitBanner:
    data = BaseRequest().api_load(path_setting.FREE_RECRUIT_BANNER)
    free_recruit_banner_case, free_recruit_banner_data = get_ids(data, "free_recruit_banner")

    @pytest.mark.parametrize("param", free_recruit_banner_data, ids=free_recruit_banner_case)
    def test_free_recruit_case(self, param):
        r = feed_request().free_recruit_banner(param["version"], param["json"])
        if r["error"] == 0:
            assert r["data"]["banner"] != param["assert"]




