import pytest

from all_backend_api.hospitals_request import hospitals_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestDetail:
    data = BaseRequest().api_load(path_setting.HOSPITAL_DETAIL)
    detail_case, detail_data = get_ids(data, "detail")

    @pytest.mark.parametrize("param", detail_data, ids=detail_case)
    def test_detail(self, param):
        r = hospitals_request().detail()

        assert r["error"] == param["assert_error"]
        assert r["data"]["base_info"]["hospital_name"] == param["assert"]
        assert r["data"]["base_info"]["good_at"][0] == param["assert1"]
        assert r["data"]["base_info"]["hospital_type"] == param["assert2"]
        assert r["data"]["buy_related"]["gifts"][0]["gift_id"] == param["assert3"]
        assert r["data"]["tab"] == param["assert4"]
        assert r["data"]["image_header_area"]["hospital_images"][0] == param["assert5"]





