import pytest
from bs4 import BeautifulSoup

import path_setting
from all_backend_api.hybrid_request import hybrid_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#百科详情页-项目百科，水光针
class TestBaseWikiItem:
    data = BaseRequest().api_load(path_setting.BASEWIKI_ITEM)
    basewiki_item_case, basewiki_item_data = get_ids(data, "basewiki_item")

    @pytest.mark.parametrize("param", basewiki_item_data, ids=basewiki_item_case)
    def test_basewiki_item(self, param):
        r = hybrid_request().basewiki_item(param["version"])
        soup = BeautifulSoup(r, 'lxml')  # html.parser是解析器，也可是lxml
        assert soup.title.string == param["assert"]
        print('进入项目百科-水光针的百科详情页')