import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.im_request import im_request


class TestConversationDetail:
    data = BaseRequest().api_load(path_setting.CONVERSATION_DETAIL)
    conversationdetail_case, conversationdetail_data = get_ids(data, "conversation_detail")

    @pytest.mark.parametrize("param",conversationdetail_data,ids=conversationdetail_case)
    def test_conversation_detail(self,param):
        r = im_request().conversation_detail(param["current_city_id"], param["begin_msg_id"], param["conversation_type"], param["end_msg_id"], param["referrer"])
        if r["error"] == 0:
            msg_list = r.get("data").get("msg_list",[])
            assert len(msg_list) > param["assert"]

