import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.janus_request import janus_request


class TestBeautyCardDetail:
    data = BaseRequest().api_load(path_setting.BEAUTY_CARD_DETAIL)
    beauty_card_detail_case, beauty_card_detail_data = get_ids(data, "beauty_card_detail")

    @pytest.mark.parametrize("param", beauty_card_detail_data, ids=beauty_card_detail_case)
    def test_beauty_card_detail(self, param):
        r = janus_request().beauty_card_detail(param["spu_id"], param["sku_id"], param["welfareId"], param["version"], param["current_city_id"], param["lat"], param["lng"])

        if r["error"] == 0:
           assert len(r["data"]["beautycart_list"]) > param["assert"]
