import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestProductMyLiSt:
    data = BaseRequest().api_load(path_setting.JANUS_PRODUCT_MY_LIST_DATA)
    product_my_list_detail_case, product_my_list_detail_data = get_ids(data, "product_my_list")

    @pytest.mark.parametrize("param", product_my_list_detail_data, ids=product_my_list_detail_case)
    def test_product_my_list(self, param):
        r = janus_request().product_my_list(param["start_num"], param["tab_id"])
        assert r["error"] == 0

        coupon_list = r["data"]["coupon_list"]
        print(len(coupon_list))
        assert 0 <= len(coupon_list) <= 20

        if len(coupon_list) < 10:
            assert r["data"]["no_more_data"] is True
